/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.sprites;

import com.watabou.noosa.Game;
import com.watabou.noosa.Image;
import com.watabou.noosa.TextureFilm;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.DungeonTilemap;
import com.watabou.pixeldungeon.plants.Plant;
import com.watabou.utils.PointF;

public class PlantSprite
extends Image {
    private static final float DELAY = 0.2f;
    private State state = State.NORMAL;
    private float time;
    private static TextureFilm frames;
    private int pos = -1;

    public PlantSprite() {
        super("plants.png");
        if (frames == null) {
            frames = new TextureFilm(this.texture, 16, 16);
        }
        this.origin.set(8.0f, 12.0f);
    }

    public PlantSprite(int image) {
        this();
        this.reset(image);
    }

    public void reset(Plant plant) {
        this.revive();
        this.reset(plant.image);
        this.alpha(1.0f);
        this.pos = plant.pos;
        PointF p = DungeonTilemap.tileToWorld(plant.pos);
        this.x = p.x;
        this.y = p.y;
        this.state = State.GROWING;
        this.time = 0.2f;
    }

    public void reset(int image) {
        this.frame(frames.get(image));
    }

    @Override
    public void update() {
        super.update();
        this.visible = this.pos == -1 || Dungeon.visible[this.pos];
        switch (this.state) {
            case GROWING: {
                float f;
                this.time -= Game.elapsed;
                if (f <= 0.0f) {
                    this.state = State.NORMAL;
                    this.scale.set(1.0f);
                    break;
                }
                this.scale.set(1.0f - this.time / 0.2f);
                break;
            }
            case WITHERING: {
                float f;
                this.time -= Game.elapsed;
                if (f <= 0.0f) {
                    super.kill();
                    break;
                }
                this.alpha(this.time / 0.2f);
                break;
            }
        }
    }

    @Override
    public void kill() {
        this.state = State.WITHERING;
        this.time = 0.2f;
    }

    private static enum State {
        GROWING,
        NORMAL,
        WITHERING;

    }
}

