/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.sprites;

import com.watabou.noosa.tweeners.PosTweener;
import com.watabou.noosa.tweeners.Tweener;
import com.watabou.pixeldungeon.DungeonTilemap;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.sprites.ItemSprite;
import com.watabou.utils.Callback;
import com.watabou.utils.PointF;

public class MissileSprite
extends ItemSprite
implements Tweener.Listener {
    private static final float SPEED = 240.0f;
    private Callback callback;

    public MissileSprite() {
        this.originToCenter();
    }

    public void reset(int from, int to, Item item, Callback listener) {
        if (item == null) {
            this.reset(from, to, 0, null, listener);
        } else {
            this.reset(from, to, item.image(), item.glowing(), listener);
        }
    }

    public void reset(int from, int to, int image, ItemSprite.Glowing glowing, Callback listener) {
        this.revive();
        this.view(image, glowing);
        this.callback = listener;
        this.point(DungeonTilemap.tileToWorld(from));
        PointF dest = DungeonTilemap.tileToWorld(to);
        PointF d = PointF.diff(dest, this.point());
        this.speed.set(d).normalize().scale(240.0f);
        if (image == 31 || image == 108 || image == 109 || image == 110) {
            this.angularSpeed = 0.0f;
            this.angle = 135.0f - (float)(Math.atan2(d.x, d.y) / 3.1415926 * 180.0);
        } else {
            this.angularSpeed = image == 15 || image == 106 ? 1440.0f : 720.0f;
        }
        PosTweener tweener = new PosTweener(this, dest, d.length() / 240.0f);
        tweener.listener = this;
        this.parent.add(tweener);
    }

    @Override
    public void onComplete(Tweener tweener) {
        this.kill();
        if (this.callback != null) {
            this.callback.call();
        }
    }
}

