/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.sprites;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.TextureData;
import com.watabou.gdx.GdxTexture;
import com.watabou.gltextures.TextureCache;
import com.watabou.noosa.Game;
import com.watabou.noosa.MovieClip;
import com.watabou.noosa.TextureFilm;
import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.effects.CellEmitter;
import com.watabou.pixeldungeon.effects.Speck;
import com.watabou.pixeldungeon.items.Gold;
import com.watabou.pixeldungeon.items.Heap;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.utils.PointF;
import com.watabou.utils.Random;

public class ItemSprite
extends MovieClip {
    public static final int SIZE = 16;
    private static final float DROP_INTERVAL = 0.4f;
    protected static TextureFilm film;
    public Heap heap;
    private Glowing glowing;
    private float phase;
    private boolean glowUp;
    private float dropInterval;

    public ItemSprite() {
        this(127, null);
    }

    public ItemSprite(Item item) {
        this(item.image(), item.glowing());
    }

    public ItemSprite(int image, Glowing glowing) {
        super("items.png");
        if (film == null) {
            film = new TextureFilm(this.texture, 16, 16);
        }
        this.view(image, glowing);
    }

    public void originToCenter() {
        this.origin.set(8.0f);
    }

    public void link() {
        this.link(this.heap);
    }

    public void link(Heap heap) {
        this.heap = heap;
        this.view(heap.image(), heap.glowing());
        this.place(heap.pos);
    }

    @Override
    public void revive() {
        super.revive();
        this.speed.set(0.0f);
        this.acc.set(0.0f);
        this.dropInterval = 0.0f;
        this.heap = null;
    }

    public PointF worldToCamera(int cell) {
        int csize = 16;
        return new PointF((float)(cell % 32 * 16) + 0.0f, (float)(cell / 32 * 16) + 0.0f);
    }

    public void place(int p) {
        this.point(this.worldToCamera(p));
    }

    public void drop() {
        if (this.heap.isEmpty()) {
            return;
        }
        this.dropInterval = 0.4f;
        this.speed.set(0.0f, -100.0f);
        this.acc.set(0.0f, -this.speed.y / 0.4f * 2.0f);
        if (this.visible && this.heap != null && this.heap.peek() instanceof Gold) {
            CellEmitter.center(this.heap.pos).burst(Speck.factory(14), 5);
            Sample.INSTANCE.play("snd_gold.mp3", 1.0f, 1.0f, Random.Float(0.9f, 1.1f));
        }
    }

    public void drop(int from) {
        if (this.heap.pos == from) {
            this.drop();
        } else {
            float px = this.x;
            float py = this.y;
            this.drop();
            this.place(from);
            this.speed.offset((px - this.x) / 0.4f, (py - this.y) / 0.4f);
        }
    }

    public ItemSprite view(int image, Glowing glowing) {
        this.frame(film.get(image));
        this.glowing = glowing;
        if (this.glowing == null) {
            this.resetColor();
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void update() {
        block7: {
            super.update();
            v0 = this.visible = this.heap == null || Dungeon.visible[this.heap.pos] != false;
            if (this.dropInterval > 0.0f) {
                this.dropInterval -= Game.elapsed;
                if (v1 <= 0.0f) {
                    this.speed.set(0.0f);
                    this.acc.set(0.0f);
                    this.place(this.heap.pos);
                    if (Level.water[this.heap.pos]) {
                        GameScene.ripple(this.heap.pos);
                    }
                }
            }
            if (!this.visible || this.glowing == null) break block7;
            if (!this.glowUp) ** GOTO lbl-1000
            this.phase += Game.elapsed;
            if (v2 > this.glowing.period) {
                this.glowUp = false;
                this.phase = this.glowing.period;
            } else if (!this.glowUp) {
                this.phase -= Game.elapsed;
                if (v3 < 0.0f) {
                    this.glowUp = true;
                    this.phase = 0.0f;
                }
            }
            value = this.phase / this.glowing.period * 0.6f;
            this.gm = this.bm = 1.0f - value;
            this.rm = this.bm;
            this.ra = this.glowing.red * value;
            this.ga = this.glowing.green * value;
            this.ba = this.glowing.blue * value;
        }
    }

    public static int pick(int index, int x, int y) {
        GdxTexture bmp = TextureCache.get((Object)"items.png").bitmap;
        int rows = bmp.getWidth() / 16;
        int row = index / rows;
        int col = index % rows;
        TextureData td = bmp.getTextureData();
        if (!td.isPrepared()) {
            td.prepare();
        }
        Pixmap pixmap = td.consumePixmap();
        int pixel = pixmap.getPixel(col * 16 + x, row * 16 + y);
        pixmap.dispose();
        return pixel;
    }

    public static class Glowing {
        public static final Glowing WHITE = new Glowing(0xFFFFFF, 0.6f);
        public float red;
        public float green;
        public float blue;
        public float period;

        public Glowing(int color) {
            this(color, 1.0f);
        }

        public Glowing(int color, float period) {
            this.red = (float)(color >> 16) / 255.0f;
            this.green = (float)(color >> 8 & 0xFF) / 255.0f;
            this.blue = (float)(color & 0xFF) / 255.0f;
            this.period = period;
        }
    }
}

