/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.sprites;

import com.watabou.gltextures.SmartTexture;
import com.watabou.gltextures.TextureCache;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Image;
import com.watabou.noosa.MovieClip;
import com.watabou.noosa.TextureFilm;
import com.watabou.noosa.Visual;
import com.watabou.noosa.tweeners.Tweener;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.actors.hero.HeroClass;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.pixeldungeon.sprites.CharSprite;
import com.watabou.utils.Callback;
import com.watabou.utils.PointF;
import com.watabou.utils.RectF;

public class HeroSprite
extends CharSprite {
    private static final int FRAME_WIDTH = 12;
    private static final int FRAME_HEIGHT = 15;
    private static final int RUN_FRAMERATE = 20;
    private static TextureFilm tiers;
    private MovieClip.Animation fly;
    private Tweener jumpTweener;
    private Callback jumpCallback;

    public HeroSprite() {
        this.link(Dungeon.hero);
        this.texture(Dungeon.hero.heroClass.spritesheet());
        this.updateArmor();
        this.idle();
    }

    public void updateArmor() {
        TextureFilm film = new TextureFilm(HeroSprite.tiers(), ((Hero)this.ch).tier(), 12, 15);
        this.idle = new MovieClip.Animation(1, true);
        this.idle.frames(film, 0, 0, 0, 1, 0, 0, 1, 1);
        this.run = new MovieClip.Animation(20, true);
        this.run.frames(film, 2, 3, 4, 5, 6, 7);
        this.die = new MovieClip.Animation(20, false);
        this.die.frames(film, 8, 9, 10, 11, 12, 11);
        this.attack = new MovieClip.Animation(15, false);
        this.attack.frames(film, 13, 14, 15, 0);
        this.zap = this.attack.clone();
        this.operate = new MovieClip.Animation(8, false);
        this.operate.frames(film, 16, 17, 16, 17);
        this.fly = new MovieClip.Animation(1, true);
        this.fly.frames(film, 18);
    }

    @Override
    public void place(int p) {
        super.place(p);
        Camera.main.target = this;
    }

    @Override
    public void move(int from, int to) {
        super.move(from, to);
        if (this.ch.flying) {
            this.play(this.fly);
        }
        Camera.main.target = this;
    }

    public void jump(int from, int to, Callback callback) {
        this.jumpCallback = callback;
        int distance = Level.distance(from, to);
        this.jumpTweener = new JumpTweener(this, this.worldToCamera(to), distance * 4, (float)distance * 0.1f);
        this.jumpTweener.listener = this;
        this.parent.add(this.jumpTweener);
        this.turnTo(from, to);
        this.play(this.fly);
    }

    @Override
    public void onComplete(Tweener tweener) {
        if (tweener == this.jumpTweener) {
            if (this.visible && Level.water[this.ch.pos] && !this.ch.flying) {
                GameScene.ripple(this.ch.pos);
            }
            if (this.jumpCallback != null) {
                this.jumpCallback.call();
            }
        } else {
            super.onComplete(tweener);
        }
    }

    @Override
    public void update() {
        this.sleeping = ((Hero)this.ch).restoreHealth;
        super.update();
    }

    public boolean sprint(boolean on) {
        this.run.delay = on ? 0.03125f : 0.05f;
        return on;
    }

    public static TextureFilm tiers() {
        if (tiers == null) {
            SmartTexture texture = TextureCache.get("rogue.png");
            tiers = new TextureFilm(texture, texture.width, 15);
        }
        return tiers;
    }

    public static Image avatar(HeroClass cl, int armorTier) {
        RectF patch = HeroSprite.tiers().get(armorTier);
        Image avatar = new Image(cl.spritesheet());
        RectF frame = avatar.texture.uvRect(1, 0, 12, 15);
        frame = frame.offset(patch.left, patch.top);
        avatar.frame(frame);
        return avatar;
    }

    private static class JumpTweener
    extends Tweener {
        public Visual visual;
        public PointF start;
        public PointF end;
        public float height;

        public JumpTweener(Visual visual, PointF pos, float height, float time) {
            super(visual, time);
            this.visual = visual;
            this.start = visual.point();
            this.end = pos;
            this.height = height;
        }

        @Override
        protected void updateValues(float progress) {
            this.visual.point(PointF.inter(this.start, this.end, progress).offset(0.0f, -this.height * 4.0f * progress * (1.0f - progress)));
        }
    }
}

