/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.sprites;

import com.watabou.noosa.Game;
import com.watabou.noosa.MovieClip;
import com.watabou.noosa.audio.Sample;
import com.watabou.noosa.particles.Emitter;
import com.watabou.noosa.tweeners.PosTweener;
import com.watabou.noosa.tweeners.Tweener;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.effects.EmoIcon;
import com.watabou.pixeldungeon.effects.FloatingText;
import com.watabou.pixeldungeon.effects.IceBlock;
import com.watabou.pixeldungeon.effects.Speck;
import com.watabou.pixeldungeon.effects.Splash;
import com.watabou.pixeldungeon.effects.TorchHalo;
import com.watabou.pixeldungeon.effects.particles.FlameParticle;
import com.watabou.pixeldungeon.items.potions.PotionOfInvisibility;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.utils.Callback;
import com.watabou.utils.PointF;
import com.watabou.utils.Random;

public class CharSprite
extends MovieClip
implements Tweener.Listener,
MovieClip.Listener {
    public static final int DEFAULT = 0xFFFFFF;
    public static final int POSITIVE = 65280;
    public static final int NEGATIVE = 0xFF0000;
    public static final int WARNING = 0xFF8800;
    public static final int NEUTRAL = 0xFFFF00;
    private static final float MOVE_INTERVAL = 0.1f;
    private static final float FLASH_INTERVAL = 0.05f;
    protected MovieClip.Animation idle;
    protected MovieClip.Animation run;
    protected MovieClip.Animation attack;
    protected MovieClip.Animation operate;
    protected MovieClip.Animation zap;
    protected MovieClip.Animation die;
    protected Callback animCallback;
    protected Tweener motion;
    protected Emitter burning;
    protected Emitter levitation;
    protected IceBlock iceBlock;
    protected TorchHalo halo;
    protected EmoIcon emo;
    private float flashTime = 0.0f;
    protected boolean sleeping = false;
    public Char ch;
    public boolean isMoving = false;

    public CharSprite() {
        this.listener = this;
    }

    public void link(Char ch) {
        this.ch = ch;
        ch.sprite = this;
        this.place(ch.pos);
        this.turnTo(ch.pos, Random.Int(1024));
        ch.updateSpriteState();
    }

    public PointF worldToCamera(int cell) {
        int csize = 16;
        return new PointF(((float)(cell % 32) + 0.5f) * 16.0f - this.width * 0.5f, ((float)(cell / 32) + 1.0f) * 16.0f - this.height);
    }

    public void place(int cell) {
        this.point(this.worldToCamera(cell));
    }

    public void showStatus(int color, String text, Object ... args) {
        if (this.visible) {
            if (args.length > 0) {
                text = Utils.format(text, args);
            }
            if (this.ch != null) {
                FloatingText.show(this.x + this.width * 0.5f, this.y, this.ch.pos, text, color);
            } else {
                FloatingText.show(this.x + this.width * 0.5f, this.y, text, color);
            }
        }
    }

    public void idle() {
        this.play(this.idle);
    }

    public void move(int from, int to) {
        this.play(this.run);
        this.motion = new PosTweener(this, this.worldToCamera(to), 0.1f);
        this.motion.listener = this;
        this.parent.add(this.motion);
        this.isMoving = true;
        this.turnTo(from, to);
        if (this.visible && Level.water[from] && !this.ch.flying) {
            GameScene.ripple(from);
        }
        this.ch.onMotionComplete();
    }

    public void interruptMotion() {
        if (this.motion != null) {
            this.onComplete(this.motion);
        }
    }

    public void attack(int cell) {
        this.turnTo(this.ch.pos, cell);
        this.play(this.attack);
    }

    public void attack(int cell, Callback callback) {
        this.animCallback = callback;
        this.turnTo(this.ch.pos, cell);
        this.play(this.attack);
    }

    public void operate(int cell) {
        this.turnTo(this.ch.pos, cell);
        this.play(this.operate);
    }

    public void zap(int cell) {
        this.turnTo(this.ch.pos, cell);
        this.play(this.zap);
    }

    public void turnTo(int from, int to) {
        int tx = to % 32;
        int fx = from % 32;
        if (tx > fx) {
            this.flipHorizontal = false;
        } else if (tx < fx) {
            this.flipHorizontal = true;
        }
    }

    public void die() {
        this.sleeping = false;
        this.play(this.die);
        if (this.emo != null) {
            this.emo.killAndErase();
        }
    }

    public Emitter emitter() {
        Emitter emitter = GameScene.emitter();
        emitter.pos(this);
        return emitter;
    }

    public Emitter centerEmitter() {
        Emitter emitter = GameScene.emitter();
        emitter.pos(this.center());
        return emitter;
    }

    public Emitter bottomEmitter() {
        Emitter emitter = GameScene.emitter();
        emitter.pos(this.x, this.y + this.height, this.width, 0.0f);
        return emitter;
    }

    public void burst(int color, int n) {
        if (this.visible) {
            Splash.at(this.center(), color, n);
        }
    }

    public void bloodBurstA(PointF from, int damage) {
        if (this.visible) {
            PointF c = this.center();
            int n = (int)Math.min(9.0 * Math.sqrt((double)damage / (double)this.ch.HT), 9.0);
            Splash.at(c, PointF.angle(from, c), 1.5707963f, this.blood(), n);
        }
    }

    public int blood() {
        return -4521984;
    }

    public void flash() {
        this.ga = 1.0f;
        this.ba = 1.0f;
        this.ra = 1.0f;
        this.flashTime = 0.05f;
    }

    public void add(State state) {
        switch (state) {
            case BURNING: {
                this.burning = this.emitter();
                this.burning.pour(FlameParticle.FACTORY, 0.06f);
                if (!this.visible) break;
                Sample.INSTANCE.play("snd_burning.mp3");
                break;
            }
            case LEVITATING: {
                this.levitation = this.emitter();
                this.levitation.pour(Speck.factory(106), 0.02f);
                break;
            }
            case INVISIBLE: {
                PotionOfInvisibility.melt(this.ch);
                break;
            }
            case PARALYSED: {
                this.paused = true;
                break;
            }
            case FROZEN: {
                this.iceBlock = IceBlock.freeze(this);
                this.paused = true;
                break;
            }
            case ILLUMINATED: {
                this.halo = new TorchHalo(this);
                GameScene.effect(this.halo);
            }
        }
    }

    public void remove(State state) {
        switch (state) {
            case BURNING: {
                if (this.burning == null) break;
                this.burning.on = false;
                this.burning = null;
                break;
            }
            case LEVITATING: {
                if (this.levitation == null) break;
                this.levitation.on = false;
                this.levitation = null;
                break;
            }
            case INVISIBLE: {
                this.alpha(1.0f);
                break;
            }
            case PARALYSED: {
                this.paused = false;
                break;
            }
            case FROZEN: {
                if (this.iceBlock != null) {
                    this.iceBlock.melt();
                    this.iceBlock = null;
                }
                this.paused = false;
                break;
            }
            case ILLUMINATED: {
                if (this.halo == null) break;
                this.halo.putOut();
            }
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.paused && this.listener != null) {
            this.listener.onComplete(this.curAnim);
        }
        if (this.flashTime > 0.0f) {
            float f;
            this.flashTime -= Game.elapsed;
            if (f <= 0.0f) {
                this.resetColor();
            }
        }
        if (this.burning != null) {
            this.burning.visible = this.visible;
        }
        if (this.levitation != null) {
            this.levitation.visible = this.visible;
        }
        if (this.iceBlock != null) {
            this.iceBlock.visible = this.visible;
        }
        if (this.sleeping) {
            this.showSleep();
        } else {
            this.hideSleep();
        }
        if (this.emo != null) {
            this.emo.visible = this.visible;
        }
    }

    public void showSleep() {
        if (!(this.emo instanceof EmoIcon.Sleep)) {
            if (this.emo != null) {
                this.emo.killAndErase();
            }
            this.emo = new EmoIcon.Sleep(this);
        }
    }

    public void hideSleep() {
        if (this.emo instanceof EmoIcon.Sleep) {
            this.emo.killAndErase();
            this.emo = null;
        }
    }

    public void showAlert() {
        if (!(this.emo instanceof EmoIcon.Alert)) {
            if (this.emo != null) {
                this.emo.killAndErase();
            }
            this.emo = new EmoIcon.Alert(this);
        }
    }

    public void hideAlert() {
        if (this.emo instanceof EmoIcon.Alert) {
            this.emo.killAndErase();
            this.emo = null;
        }
    }

    @Override
    public void kill() {
        super.kill();
        if (this.emo != null) {
            this.emo.killAndErase();
            this.emo = null;
        }
    }

    @Override
    public void onComplete(Tweener tweener) {
        if (tweener == this.motion) {
            this.isMoving = false;
            this.motion.killAndErase();
            this.motion = null;
        }
    }

    @Override
    public void onComplete(MovieClip.Animation anim) {
        if (this.animCallback != null) {
            this.animCallback.call();
            this.animCallback = null;
        } else if (anim == this.attack) {
            this.idle();
            this.ch.onAttackComplete();
        } else if (anim == this.operate) {
            this.idle();
            this.ch.onOperateComplete();
        }
    }

    public static enum State {
        BURNING,
        LEVITATING,
        INVISIBLE,
        PARALYSED,
        FROZEN,
        ILLUMINATED;

    }
}

