/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.sprites;

import com.watabou.noosa.MovieClip;
import com.watabou.noosa.TextureFilm;
import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.effects.MagicMissile;
import com.watabou.pixeldungeon.sprites.MobSprite;
import com.watabou.utils.Callback;

public class BurningFistSprite
extends MobSprite {
    private int posToShoot;

    public BurningFistSprite() {
        this.texture("burning_fist.png");
        TextureFilm frames = new TextureFilm(this.texture, 24, 17);
        this.idle = new MovieClip.Animation(2, true);
        this.idle.frames(frames, 0, 0, 1);
        this.run = new MovieClip.Animation(3, true);
        this.run.frames(frames, 0, 1);
        this.attack = new MovieClip.Animation(8, false);
        this.attack.frames(frames, 0, 5, 6);
        this.die = new MovieClip.Animation(10, false);
        this.die.frames(frames, 0, 2, 3, 4);
        this.play(this.idle);
    }

    @Override
    public void attack(int cell) {
        this.posToShoot = cell;
        super.attack(cell);
    }

    @Override
    public void onComplete(MovieClip.Animation anim) {
        if (anim == this.attack) {
            Sample.INSTANCE.play("snd_zap.mp3");
            MagicMissile.shadow(this.parent, this.ch.pos, this.posToShoot, new Callback(){

                @Override
                public void call() {
                    BurningFistSprite.this.ch.onAttackComplete();
                }
            });
            this.idle();
        } else {
            super.onComplete(anim);
        }
    }
}

