/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.scenes;

import com.watabou.noosa.BitmapText;
import com.watabou.noosa.BitmapTextMultiline;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Game;
import com.watabou.noosa.Group;
import com.watabou.noosa.Image;
import com.watabou.noosa.audio.Sample;
import com.watabou.noosa.particles.Emitter;
import com.watabou.noosa.ui.Button;
import com.watabou.pixeldungeon.Badges;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.GamesInProgress;
import com.watabou.pixeldungeon.PixelDungeon;
import com.watabou.pixeldungeon.actors.hero.HeroClass;
import com.watabou.pixeldungeon.effects.BannerSprites;
import com.watabou.pixeldungeon.effects.Speck;
import com.watabou.pixeldungeon.input.GameAction;
import com.watabou.pixeldungeon.scenes.InterlevelScene;
import com.watabou.pixeldungeon.scenes.IntroScene;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.scenes.TitleScene;
import com.watabou.pixeldungeon.ui.Archs;
import com.watabou.pixeldungeon.ui.ExitButton;
import com.watabou.pixeldungeon.ui.Icons;
import com.watabou.pixeldungeon.ui.RedButton;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.pixeldungeon.windows.WndChallenges;
import com.watabou.pixeldungeon.windows.WndClass;
import com.watabou.pixeldungeon.windows.WndMessage;
import com.watabou.pixeldungeon.windows.WndOptions;
import java.util.HashMap;

public class StartScene
extends PixelScene {
    private static final float BUTTON_HEIGHT = 24.0f;
    private static final float GAP = 2.0f;
    private static final String TXT_LOAD = "Load Game";
    private static final String TXT_NEW = "New Game";
    private static final String TXT_ERASE = "Erase current game";
    private static final String TXT_DPTH_LVL = "Depth: %d, level: %d";
    private static final String TXT_REALLY = "Do you really want to start new game?";
    private static final String TXT_WARNING = "Your current game progress will be erased.";
    private static final String TXT_YES = "Yes, start new game";
    private static final String TXT_NO = "No, return to main menu";
    private static final String TXT_UNLOCK = "To unlock this character class, slay the 3rd boss with any other class";
    private static final String TXT_WIN_THE_GAME = "To unlock \"Challenges\", win the game with any character class.";
    private static final float WIDTH = 116.0f;
    private static final float HEIGHT = 220.0f;
    private static HashMap<HeroClass, ClassShield> shields = new HashMap();
    private GameButton btnLoad;
    private GameButton btnNewGame;
    private boolean huntressUnlocked;
    private Group unlock;
    public static HeroClass curClass;

    @Override
    public void create() {
        super.create();
        Badges.loadGlobal();
        StartScene.uiCamera.visible = false;
        int w = Camera.main.width;
        int h = Camera.main.height;
        float left = ((float)w - 116.0f) / 2.0f;
        float top = ((float)h - 220.0f) / 2.0f;
        float bottom = (float)h - top;
        Archs archs = new Archs();
        archs.setSize(w, h);
        this.add(archs);
        Image title = BannerSprites.get(BannerSprites.Type.SELECT_YOUR_HERO);
        title.x = StartScene.align(((float)w - title.width()) / 2.0f);
        title.y = top;
        this.add(title);
        this.btnNewGame = new GameButton(TXT_NEW){

            @Override
            protected void onClick() {
                if (GamesInProgress.check(curClass) != null) {
                    StartScene.this.add(new WndOptions(StartScene.TXT_REALLY, StartScene.TXT_WARNING, new String[]{StartScene.TXT_YES, StartScene.TXT_NO}){

                        @Override
                        protected void onSelect(int index) {
                            if (index == 0) {
                                StartScene.this.startNewGame();
                            }
                        }
                    });
                } else {
                    StartScene.this.startNewGame();
                }
            }
        };
        this.add(this.btnNewGame);
        this.btnLoad = new GameButton(TXT_LOAD){

            @Override
            protected void onClick() {
                InterlevelScene.mode = InterlevelScene.Mode.CONTINUE;
                Game.switchScene(InterlevelScene.class);
            }
        };
        this.add(this.btnLoad);
        HeroClass[] classes = new HeroClass[]{HeroClass.WARRIOR, HeroClass.MAGE, HeroClass.ROGUE, HeroClass.HUNTRESS};
        float shieldW = 58.0f;
        float shieldH = Math.min((bottom - 24.0f - title.y - title.height()) / 2.0f, shieldW * 1.2f);
        top = (bottom - 24.0f + title.y + title.height() - shieldH * 2.0f) / 2.0f;
        for (int i = 0; i < classes.length; ++i) {
            ClassShield shield = new ClassShield(classes[i]);
            shield.setRect(left + (float)(i % 2) * shieldW, top + (float)(i / 2) * shieldH, shieldW, shieldH);
            this.add(shield);
            shields.put(classes[i], shield);
        }
        this.unlock = new Group();
        this.add(this.unlock);
        ChallengeButton challenge = new ChallengeButton();
        challenge.setPos((float)(w / 2) - challenge.width() / 2.0f, top + shieldH - challenge.height() / 2.0f);
        this.add(challenge);
        this.huntressUnlocked = Badges.isUnlocked(Badges.Badge.BOSS_SLAIN_3);
        if (!this.huntressUnlocked) {
            BitmapTextMultiline text = PixelScene.createMultiline(TXT_UNLOCK, 9.0f);
            text.maxWidth = 116;
            text.measure();
            float pos = bottom - 24.0f + (24.0f - text.height()) / 2.0f;
            for (BitmapText line : new BitmapTextMultiline.LineSplitter(text).split()) {
                line.measure();
                line.hardlight(0xFFFF00);
                line.x = PixelScene.align(left + 58.0f - line.width() / 2.0f);
                line.y = PixelScene.align(pos);
                this.unlock.add(line);
                pos += line.height();
            }
        }
        ExitButton btnExit = new ExitButton();
        btnExit.setPos((float)Camera.main.width - btnExit.width(), 0.0f);
        this.add(btnExit);
        curClass = null;
        this.updateClass(HeroClass.values()[PixelDungeon.lastClass()]);
        this.fadeIn();
    }

    private void updateClass(HeroClass cl) {
        if (curClass == cl) {
            this.add(new WndClass(cl));
            return;
        }
        if (curClass != null) {
            shields.get((Object)curClass).highlight(false);
        }
        curClass = cl;
        shields.get((Object)curClass).highlight(true);
        if (cl != HeroClass.HUNTRESS || this.huntressUnlocked) {
            this.unlock.visible = false;
            float buttonPos = ((float)Camera.main.height + 220.0f) / 2.0f - 24.0f;
            float left = ((float)Camera.main.width - 116.0f) / 2.0f;
            GamesInProgress.Info info = GamesInProgress.check(curClass);
            if (info != null) {
                this.btnLoad.visible = true;
                this.btnLoad.secondary(Utils.format(TXT_DPTH_LVL, info.depth, info.level));
                this.btnNewGame.visible = true;
                this.btnNewGame.secondary(TXT_ERASE);
                float w = 57.0f;
                this.btnLoad.setRect(left, buttonPos, w, 24.0f);
                this.btnNewGame.setRect(this.btnLoad.right() + 2.0f, buttonPos, w, 24.0f);
            } else {
                this.btnLoad.visible = false;
                this.btnNewGame.visible = true;
                this.btnNewGame.secondary(null);
                this.btnNewGame.setRect(left, buttonPos, 116.0f, 24.0f);
            }
        } else {
            this.unlock.visible = true;
            this.btnLoad.visible = false;
            this.btnNewGame.visible = false;
        }
    }

    private void startNewGame() {
        Dungeon.hero = null;
        InterlevelScene.mode = InterlevelScene.Mode.DESCEND;
        if (PixelDungeon.intro()) {
            PixelDungeon.intro(false);
            Game.switchScene(IntroScene.class);
        } else {
            Game.switchScene(InterlevelScene.class);
        }
    }

    @Override
    protected void onBackPressed() {
        PixelDungeon.switchNoFade(TitleScene.class);
    }

    private class ChallengeButton
    extends Button {
        private Image image;

        public ChallengeButton() {
            this.width = this.image.width;
            this.height = this.image.height;
            this.image.am = Badges.isUnlocked(Badges.Badge.VICTORY) ? 1.0f : 0.5f;
        }

        @Override
        protected void createChildren() {
            super.createChildren();
            this.image = Icons.get(PixelDungeon.challenges() > 0 ? Icons.CHALLENGE_ON : Icons.CHALLENGE_OFF);
            this.add(this.image);
        }

        @Override
        protected void layout() {
            super.layout();
            this.image.x = PixelScene.align(this.x);
            this.image.y = PixelScene.align(this.y);
        }

        @Override
        protected void onClick() {
            if (Badges.isUnlocked(Badges.Badge.VICTORY)) {
                this.add(new WndChallenges(PixelDungeon.challenges(), true){

                    @Override
                    public void onBackPressed() {
                        super.onBackPressed();
                        ChallengeButton.this.image.copy(Icons.get(PixelDungeon.challenges() > 0 ? Icons.CHALLENGE_ON : Icons.CHALLENGE_OFF));
                    }
                });
            } else {
                this.add(new WndMessage(StartScene.TXT_WIN_THE_GAME));
            }
        }

        @Override
        protected void onTouchDown() {
            Sample.INSTANCE.play("snd_click.mp3");
        }
    }

    private class ClassShield
    extends Button<GameAction> {
        private static final float MIN_BRIGHTNESS = 0.6f;
        private static final int WIDTH = 24;
        private static final int HEIGHT = 28;
        private static final int SCALE = 2;
        private HeroClass cl;
        private Image avatar;
        private BitmapText name;
        private Emitter emitter;
        private float brightness;

        public ClassShield(HeroClass cl) {
            this.cl = cl;
            this.avatar.frame(cl.ordinal() * 24, 0, 24, 28);
            this.avatar.scale.set(2.0f);
            this.name.text(cl.name());
            this.name.measure();
            this.brightness = 0.6f;
            this.updateBrightness();
        }

        @Override
        protected void createChildren() {
            super.createChildren();
            this.avatar = new Image("avatars.png");
            this.add(this.avatar);
            this.name = PixelScene.createText(9.0f);
            this.add(this.name);
            this.emitter = new Emitter();
            this.add(this.emitter);
        }

        @Override
        protected void layout() {
            super.layout();
            this.avatar.x = PixelScene.align(this.x + (this.width - this.avatar.width()) / 2.0f);
            this.avatar.y = PixelScene.align(this.y + (this.height - this.avatar.height() - this.name.height()) / 2.0f);
            this.name.x = PixelScene.align(this.x + (this.width - this.name.width()) / 2.0f);
            this.name.y = this.avatar.y + this.avatar.height() + 2.0f;
            this.emitter.pos(this.avatar.x, this.avatar.y, this.avatar.width(), this.avatar.height());
        }

        @Override
        protected void onTouchDown() {
            this.emitter.revive();
            this.emitter.start(Speck.factory(2), 0.05f, 7);
            Sample.INSTANCE.play("snd_click.mp3", 1.0f, 1.0f, 1.2f);
            StartScene.this.updateClass(this.cl);
        }

        @Override
        public void update() {
            super.update();
            if (this.brightness < 1.0f && this.brightness > 0.6f) {
                float f;
                this.brightness -= Game.elapsed;
                if (f <= 0.6f) {
                    this.brightness = 0.6f;
                }
                this.updateBrightness();
            }
        }

        public void highlight(boolean value) {
            if (value) {
                this.brightness = 1.0f;
                this.name.hardlight(13291458);
            } else {
                this.brightness = 0.999f;
                this.name.hardlight(0x444444);
            }
            this.updateBrightness();
        }

        private void updateBrightness() {
            this.avatar.rm = this.avatar.am = this.brightness;
            this.avatar.bm = this.avatar.am;
            this.avatar.gm = this.avatar.am;
        }
    }

    private static class GameButton
    extends RedButton {
        private static final int SECONDARY_COLOR = 13291458;
        private BitmapText secondary;

        public GameButton(String primary) {
            super(primary);
            this.secondary.text(null);
        }

        @Override
        protected void createChildren() {
            super.createChildren();
            this.secondary = PixelScene.createText(6.0f);
            this.secondary.hardlight(13291458);
            this.add(this.secondary);
        }

        @Override
        protected void layout() {
            super.layout();
            if (this.secondary.text().length() > 0) {
                this.text.y = PixelScene.align(this.y + (this.height - this.text.height() - this.secondary.baseLine()) / 2.0f);
                this.secondary.x = PixelScene.align(this.x + (this.width - this.secondary.width()) / 2.0f);
                this.secondary.y = PixelScene.align(this.text.y + this.text.height());
            } else {
                this.text.y = PixelScene.align(this.y + (this.height - this.text.baseLine()) / 2.0f);
            }
        }

        public void secondary(String text) {
            this.secondary.text(text);
            this.secondary.measure();
        }
    }
}

