/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.scenes;

import com.badlogic.gdx.Gdx;
import com.watabou.noosa.BitmapText;
import com.watabou.noosa.BitmapTextMultiline;
import com.watabou.noosa.Camera;
import com.watabou.noosa.ColorBlock;
import com.watabou.noosa.Game;
import com.watabou.noosa.Scene;
import com.watabou.noosa.Visual;
import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.Badges;
import com.watabou.pixeldungeon.PixelDungeon;
import com.watabou.pixeldungeon.effects.BadgeBanner;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.utils.BitmapCache;

public class PixelScene
extends Scene {
    public static final float MIN_WIDTH = 128.0f;
    public static final float MIN_HEIGHT = 224.0f;
    public static float defaultZoom = 0.0f;
    public static float minZoom;
    public static float maxZoom;
    public static boolean landscapeAvailable;
    public static Camera uiCamera;
    public static BitmapText.Font font1x;
    public static BitmapText.Font font15x;
    public static BitmapText.Font font2x;
    public static BitmapText.Font font25x;
    public static BitmapText.Font font3x;
    public static BitmapText.Font font;
    public static float scale;
    public static boolean noFade;

    @Override
    public void create() {
        super.create();
        GameScene.scene = null;
        for (defaultZoom = (float)((int)Math.ceil((double)Game.density * 2.5)); ((float)Game.width / defaultZoom < 128.0f || (float)Game.height / defaultZoom < 224.0f) && defaultZoom > 1.0f; defaultZoom -= 1.0f) {
        }
        boolean bl = landscapeAvailable = (float)Game.height / defaultZoom >= 128.0f && (float)Game.width / defaultZoom >= 224.0f;
        if (PixelDungeon.scaleUp()) {
            while ((float)Game.width / (defaultZoom + 1.0f) >= 128.0f && (float)Game.height / (defaultZoom + 1.0f) >= 224.0f) {
                defaultZoom += 1.0f;
            }
        }
        minZoom = 1.0f;
        maxZoom = defaultZoom * 2.0f;
        Camera.reset(new PixelCamera(defaultZoom));
        float uiZoom = defaultZoom;
        uiCamera = Camera.createFullscreen(uiZoom);
        Camera.add(uiCamera);
        if (font1x == null) {
            font1x = BitmapText.Font.colorMarked(BitmapCache.get("font1x.png"), 0, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f");
            PixelScene.font1x.baseLine = 6.0f;
            PixelScene.font1x.tracking = -1.0f;
            font15x = BitmapText.Font.colorMarked(BitmapCache.get("font15x.png"), 12, 0, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f");
            PixelScene.font15x.baseLine = 9.0f;
            PixelScene.font15x.tracking = -1.0f;
            font2x = BitmapText.Font.colorMarked(BitmapCache.get("font2x.png"), 14, 0, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f");
            PixelScene.font2x.baseLine = 11.0f;
            PixelScene.font2x.tracking = -1.0f;
            font25x = BitmapText.Font.colorMarked(BitmapCache.get("font25x.png"), 17, 0, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f");
            PixelScene.font25x.baseLine = 13.0f;
            PixelScene.font25x.tracking = -1.0f;
            font3x = BitmapText.Font.colorMarked(BitmapCache.get("font3x.png"), 22, 0, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f");
            PixelScene.font3x.baseLine = 17.0f;
            PixelScene.font3x.tracking = -2.0f;
        }
        Sample.INSTANCE.load("snd_click.mp3", "snd_badge.mp3", "snd_gold.mp3");
    }

    @Override
    public void destroy() {
        super.destroy();
        Game.instance.getInputProcessor().removeAllTouchEvent();
    }

    public static void chooseFont(float size) {
        PixelScene.chooseFont(size, defaultZoom);
    }

    public static void chooseFont(float size, float zoom) {
        float pt = size * zoom;
        if (pt >= 19.0f) {
            scale = pt / 19.0f;
            if (1.5 <= (double)scale && scale < 2.0f) {
                font = font25x;
                scale = (int)(pt / 14.0f);
            } else {
                font = font3x;
                scale = (int)scale;
            }
        } else if (pt >= 14.0f) {
            scale = pt / 14.0f;
            if (1.8 <= (double)scale && scale < 2.0f) {
                font = font2x;
                scale = (int)(pt / 12.0f);
            } else {
                font = font25x;
                scale = (int)scale;
            }
        } else if (pt >= 12.0f) {
            scale = pt / 12.0f;
            if (1.7 <= (double)scale && scale < 2.0f) {
                font = font15x;
                scale = (int)(pt / 10.0f);
            } else {
                font = font2x;
                scale = (int)scale;
            }
        } else if (pt >= 10.0f) {
            scale = pt / 10.0f;
            if (1.4 <= (double)scale && scale < 2.0f) {
                font = font1x;
                scale = (int)(pt / 7.0f);
            } else {
                font = font15x;
                scale = (int)scale;
            }
        } else {
            font = font1x;
            scale = Math.max(1, (int)(pt / 7.0f));
        }
        scale /= zoom;
    }

    public static BitmapText createText(float size) {
        return PixelScene.createText(null, size);
    }

    public static BitmapText createText(String text, float size) {
        PixelScene.chooseFont(size);
        BitmapText result = new BitmapText(text, font);
        result.scale.set(scale);
        return result;
    }

    public static BitmapTextMultiline createMultiline(float size) {
        return PixelScene.createMultiline(null, size);
    }

    public static BitmapTextMultiline createMultiline(String text, float size) {
        PixelScene.chooseFont(size);
        BitmapTextMultiline result = new BitmapTextMultiline(text, font);
        result.scale.set(scale);
        return result;
    }

    public static float align(Camera camera, float pos) {
        return (float)((int)(pos * camera.zoom)) / camera.zoom;
    }

    public static float align(float pos) {
        return (float)((int)(pos * defaultZoom)) / defaultZoom;
    }

    public static void align(Visual v) {
        Camera c = v.camera();
        v.x = PixelScene.align(c, v.x);
        v.y = PixelScene.align(c, v.y);
    }

    protected void fadeIn() {
        if (noFade) {
            noFade = false;
        } else {
            this.fadeIn(-16777216, false);
        }
    }

    protected void fadeIn(int color, boolean light) {
        this.add(new Fader(color, light));
    }

    public static void showBadge(Badges.Badge badge) {
        BadgeBanner banner = BadgeBanner.show(badge.image);
        banner.camera = uiCamera;
        banner.x = PixelScene.align(banner.camera, ((float)banner.camera.width - banner.width) / 2.0f);
        banner.y = PixelScene.align(banner.camera, ((float)banner.camera.height - banner.height) / 3.0f);
        Game.scene().add(banner);
    }

    static {
        noFade = false;
    }

    private static class PixelCamera
    extends Camera {
        public PixelCamera(float zoom) {
            super((int)((double)Game.width - Math.ceil((float)Game.width / zoom) * (double)zoom) / 2, (int)((double)Game.height - Math.ceil((float)Game.height / zoom) * (double)zoom) / 2, (int)Math.ceil((float)Game.width / zoom), (int)Math.ceil((float)Game.height / zoom), zoom);
        }

        @Override
        protected void updateMatrix() {
            float sx = PixelScene.align(this, this.scroll.x + this.shakeX);
            float sy = PixelScene.align(this, this.scroll.y + this.shakeY);
            this.matrix[0] = this.zoom * invW2;
            this.matrix[5] = -this.zoom * invH2;
            this.matrix[12] = -1.0f + (float)this.x * invW2 - sx * this.matrix[0];
            this.matrix[13] = 1.0f - (float)this.y * invH2 - sy * this.matrix[5];
        }
    }

    protected static class Fader
    extends ColorBlock {
        private static float FADE_TIME = 1.0f;
        private boolean light;
        private float time;

        public Fader(int color, boolean light) {
            super(PixelScene.uiCamera.width, PixelScene.uiCamera.height, color);
            this.light = light;
            this.camera = uiCamera;
            this.alpha(1.0f);
            this.time = FADE_TIME;
        }

        @Override
        public void update() {
            float f;
            super.update();
            this.time -= Game.elapsed;
            if (f <= 0.0f) {
                this.alpha(0.0f);
                this.parent.remove(this);
            } else {
                this.alpha(this.time / FADE_TIME);
            }
        }

        @Override
        public void draw() {
            if (this.light) {
                Gdx.gl.glBlendFunc(770, 1);
                super.draw();
                Gdx.gl.glBlendFunc(770, 771);
            } else {
                super.draw();
            }
        }
    }
}

