/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.scenes;

import com.watabou.noosa.BitmapText;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Game;
import com.watabou.noosa.audio.Music;
import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.Statistics;
import com.watabou.pixeldungeon.actors.Actor;
import com.watabou.pixeldungeon.items.Generator;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.scenes.StartScene;
import com.watabou.pixeldungeon.windows.WndError;
import java.io.FileNotFoundException;

public class InterlevelScene
extends PixelScene {
    private static final float TIME_TO_FADE = 0.3f;
    private static final String TXT_DESCENDING = "Descending...";
    private static final String TXT_ASCENDING = "Ascending...";
    private static final String TXT_LOADING = "Loading...";
    private static final String TXT_RESURRECTING = "Resurrecting...";
    private static final String TXT_RETURNING = "Returning...";
    private static final String TXT_FALLING = "Falling...";
    private static final String ERR_FILE_NOT_FOUND = "File not found. For some reason.";
    private static final String ERR_GENERIC = "Something went wrong...";
    public static Mode mode;
    public static int returnDepth;
    public static int returnPos;
    public static boolean noStory;
    public static boolean fallIntoPit;
    private Phase phase;
    private float timeLeft;
    private BitmapText message;
    private Thread thread;
    private String error = null;

    @Override
    public void create() {
        super.create();
        String text = "";
        switch (mode) {
            case DESCEND: {
                text = TXT_DESCENDING;
                break;
            }
            case ASCEND: {
                text = TXT_ASCENDING;
                break;
            }
            case CONTINUE: {
                text = TXT_LOADING;
                break;
            }
            case RESURRECT: {
                text = TXT_RESURRECTING;
                break;
            }
            case RETURN: {
                text = TXT_RETURNING;
                break;
            }
            case FALL: {
                text = TXT_FALLING;
            }
        }
        this.message = PixelScene.createText(text, 9.0f);
        this.message.measure();
        this.message.x = ((float)Camera.main.width - this.message.width()) / 2.0f;
        this.message.y = ((float)Camera.main.height - this.message.height()) / 2.0f;
        this.add(this.message);
        this.phase = Phase.FADE_IN;
        this.timeLeft = 0.3f;
        this.thread = new Thread(){

            @Override
            public void run() {
                try {
                    Generator.reset();
                    Sample.INSTANCE.load("snd_door_open.mp3", "snd_unlock.mp3", "snd_item.mp3", "snd_dewdrop.mp3", "snd_hit.mp3", "snd_miss.mp3", "snd_step.mp3", "snd_water.mp3", "snd_descend.mp3", "snd_eat.mp3", "snd_read.mp3", "snd_lullaby.mp3", "snd_drink.mp3", "snd_shatter.mp3", "snd_zap.mp3", "snd_lightning.mp3", "snd_levelup.mp3", "snd_death.mp3", "snd_challenge.mp3", "snd_cursed.mp3", "snd_evoke.mp3", "snd_trap.mp3", "snd_tomb.mp3", "snd_alert.mp3", "snd_meld.mp3", "snd_boss.mp3", "snd_blast.mp3", "snd_plant.mp3", "snd_ray.mp3", "snd_beacon.mp3", "snd_teleport.mp3", "snd_charms.mp3", "snd_mastery.mp3", "snd_puff.mp3", "snd_rocks.mp3", "snd_burning.mp3", "snd_falling.mp3", "snd_ghost.mp3", "snd_secret.mp3", "snd_bones.mp3");
                    switch (mode) {
                        case DESCEND: {
                            InterlevelScene.this.descend();
                            break;
                        }
                        case ASCEND: {
                            InterlevelScene.this.ascend();
                            break;
                        }
                        case CONTINUE: {
                            InterlevelScene.this.restore();
                            break;
                        }
                        case RESURRECT: {
                            InterlevelScene.this.resurrect();
                            break;
                        }
                        case RETURN: {
                            InterlevelScene.this.returnTo();
                            break;
                        }
                        case FALL: {
                            InterlevelScene.this.fall();
                        }
                    }
                    if (Dungeon.depth % 5 == 0) {
                        Sample.INSTANCE.load("snd_boss.mp3");
                    }
                }
                catch (FileNotFoundException e) {
                    InterlevelScene.this.error = InterlevelScene.ERR_FILE_NOT_FOUND;
                }
                catch (Exception e) {
                    InterlevelScene.this.error = InterlevelScene.ERR_GENERIC;
                }
                if (InterlevelScene.this.phase == Phase.STATIC && InterlevelScene.this.error == null) {
                    InterlevelScene.this.phase = Phase.FADE_OUT;
                    InterlevelScene.this.timeLeft = 0.3f;
                }
            }
        };
        this.thread.start();
    }

    @Override
    public void update() {
        super.update();
        float p = this.timeLeft / 0.3f;
        switch (this.phase) {
            case FADE_IN: {
                float f;
                this.message.alpha(1.0f - p);
                this.timeLeft -= Game.elapsed;
                if (!(f <= 0.0f)) break;
                if (!this.thread.isAlive() && this.error == null) {
                    this.phase = Phase.FADE_OUT;
                    this.timeLeft = 0.3f;
                    break;
                }
                this.phase = Phase.STATIC;
                break;
            }
            case FADE_OUT: {
                float f;
                this.message.alpha(p);
                if (mode == Mode.CONTINUE || mode == Mode.DESCEND && Dungeon.depth == 1) {
                    Music.INSTANCE.volume(p);
                }
                this.timeLeft -= Game.elapsed;
                if (!(f <= 0.0f)) break;
                Game.switchScene(GameScene.class);
                break;
            }
            case STATIC: {
                if (this.error == null) break;
                this.add(new WndError(this.error){

                    @Override
                    public void onBackPressed() {
                        super.onBackPressed();
                        Game.switchScene(StartScene.class);
                    }
                });
                this.error = null;
            }
        }
    }

    private void descend() throws Exception {
        Level level;
        Actor.fixTime();
        if (Dungeon.hero == null) {
            Dungeon.init();
            if (noStory) {
                Dungeon.chapters.add(0);
                noStory = false;
            }
        } else {
            Dungeon.saveLevel();
        }
        if (Dungeon.depth >= Statistics.deepestFloor) {
            level = Dungeon.newLevel();
        } else {
            ++Dungeon.depth;
            level = Dungeon.loadLevel(Dungeon.hero.heroClass);
        }
        Dungeon.switchLevel(level, level.entrance);
    }

    private void fall() throws Exception {
        Level level;
        Actor.fixTime();
        Dungeon.saveLevel();
        if (Dungeon.depth >= Statistics.deepestFloor) {
            level = Dungeon.newLevel();
        } else {
            ++Dungeon.depth;
            level = Dungeon.loadLevel(Dungeon.hero.heroClass);
        }
        Dungeon.switchLevel(level, fallIntoPit ? level.pitCell() : level.randomRespawnCell());
    }

    private void ascend() throws Exception {
        Actor.fixTime();
        Dungeon.saveLevel();
        --Dungeon.depth;
        Level level = Dungeon.loadLevel(Dungeon.hero.heroClass);
        Dungeon.switchLevel(level, level.exit);
    }

    private void returnTo() throws Exception {
        Actor.fixTime();
        Dungeon.saveLevel();
        Dungeon.depth = returnDepth;
        Level level = Dungeon.loadLevel(Dungeon.hero.heroClass);
        Dungeon.switchLevel(level, Level.resizingNeeded ? level.adjustPos(returnPos) : returnPos);
    }

    private void restore() throws Exception {
        Actor.fixTime();
        Dungeon.loadGame(StartScene.curClass);
        if (Dungeon.depth == -1) {
            Dungeon.depth = Statistics.deepestFloor;
            Dungeon.switchLevel(Dungeon.loadLevel(StartScene.curClass), -1);
        } else {
            Level level = Dungeon.loadLevel(StartScene.curClass);
            Dungeon.switchLevel(level, Level.resizingNeeded ? level.adjustPos(Dungeon.hero.pos) : Dungeon.hero.pos);
        }
    }

    private void resurrect() throws Exception {
        Actor.fixTime();
        if (Dungeon.bossLevel()) {
            Dungeon.hero.resurrect(Dungeon.depth);
            --Dungeon.depth;
            Level level = Dungeon.newLevel();
            Dungeon.switchLevel(level, level.entrance);
        } else {
            Dungeon.hero.resurrect(-1);
            Dungeon.resetLevel();
        }
    }

    @Override
    protected void onBackPressed() {
    }

    static {
        noStory = false;
    }

    private static enum Phase {
        FADE_IN,
        STATIC,
        FADE_OUT;

    }

    public static enum Mode {
        DESCEND,
        ASCEND,
        CONTINUE,
        RESURRECT,
        RETURN,
        FALL;

    }
}

