/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.scenes;

import com.watabou.input.NoosaInputProcessor;
import com.watabou.noosa.TouchArea;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.DungeonTilemap;
import com.watabou.pixeldungeon.PixelDungeon;
import com.watabou.pixeldungeon.input.GameAction;
import com.watabou.pixeldungeon.input.PDInputProcessor;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.utils.GameMath;
import com.watabou.utils.Point;
import com.watabou.utils.PointF;

public class CellSelector
extends TouchArea<GameAction> {
    public Listener listener = null;
    public boolean enabled;
    private float mouseZoom;
    private float dragThreshold;
    private boolean pinching = false;
    private NoosaInputProcessor.Touch another;
    private float startZoom;
    private float startSpan;
    private boolean dragging = false;
    private PointF lastPos = new PointF();

    public CellSelector(DungeonTilemap map) {
        super(map);
        this.camera = map.camera();
        this.mouseZoom = this.camera.zoom;
        this.dragThreshold = PixelScene.defaultZoom * 16.0f / 2.0f;
    }

    @Override
    protected void onClick(NoosaInputProcessor.Touch touch) {
        if (this.dragging) {
            this.dragging = false;
        } else {
            this.select(((DungeonTilemap)this.target).screenToTile((int)touch.current.x, (int)touch.current.y));
        }
    }

    @Override
    public boolean onKeyDown(NoosaInputProcessor.Key<GameAction> key) {
        switch ((GameAction)((Object)key.action)) {
            case ZOOM_IN: {
                this.zoom(this.camera.zoom + 1.0f);
                return true;
            }
            case ZOOM_OUT: {
                this.zoom(this.camera.zoom - 1.0f);
                return true;
            }
            case ZOOM_DEFAULT: {
                this.zoom(PixelScene.defaultZoom);
                return true;
            }
        }
        boolean handled = true;
        int x = 0;
        int y = 0;
        switch ((GameAction)((Object)key.action)) {
            case MOVE_UP: {
                y = -1;
                break;
            }
            case MOVE_DOWN: {
                y = 1;
                break;
            }
            case MOVE_LEFT: {
                x = -1;
                break;
            }
            case MOVE_RIGHT: {
                x = 1;
                break;
            }
            case MOVE_TOP_LEFT: {
                x = -1;
                y = -1;
                break;
            }
            case MOVE_TOP_RIGHT: {
                x = 1;
                y = -1;
                break;
            }
            case MOVE_BOTTOM_LEFT: {
                x = -1;
                y = 1;
                break;
            }
            case MOVE_BOTTOM_RIGHT: {
                x = 1;
                y = 1;
                break;
            }
            case OPERATE: {
                break;
            }
            default: {
                handled = false;
            }
        }
        if (handled) {
            Point point = DungeonTilemap.tileToPoint(Dungeon.hero.pos);
            point.x += x;
            point.y += y;
            this.select(DungeonTilemap.pointToTile(point));
        }
        return handled;
    }

    @Override
    public boolean onKeyUp(NoosaInputProcessor.Key<GameAction> key) {
        switch (key.code) {
            case 129: {
                this.mouseZoom = this.zoom(Math.round(this.mouseZoom));
                return true;
            }
        }
        return false;
    }

    private float zoom(float value) {
        value = GameMath.gate(PixelScene.minZoom, value, PixelScene.maxZoom);
        PixelDungeon.zoom((int)(value - PixelScene.defaultZoom));
        this.camera.zoom(value);
        return value;
    }

    public void select(int cell) {
        if (this.enabled && this.listener != null && cell != -1) {
            this.listener.onSelect(cell);
            GameScene.ready();
        } else {
            GameScene.cancel();
        }
    }

    @Override
    protected void onTouchDown(NoosaInputProcessor.Touch t) {
        if (t != this.touch && this.another == null) {
            if (!this.touch.down) {
                this.touch = t;
                this.onTouchDown(t);
                return;
            }
            this.pinching = true;
            this.another = t;
            this.startSpan = PointF.distance(this.touch.current, this.another.current);
            this.startZoom = this.camera.zoom;
            this.dragging = false;
        }
    }

    @Override
    protected void onTouchUp(NoosaInputProcessor.Touch t) {
        if (this.pinching && (t == this.touch || t == this.another)) {
            this.pinching = false;
            int zoom = Math.round(this.camera.zoom);
            this.camera.zoom(zoom);
            PixelDungeon.zoom((int)((float)zoom - PixelScene.defaultZoom));
            this.dragging = true;
            if (t == this.touch) {
                this.touch = this.another;
            }
            this.another = null;
            this.lastPos.set(this.touch.current);
        }
    }

    @Override
    public boolean onMouseScroll(int scroll) {
        this.mouseZoom -= (float)scroll / 3.0f;
        if (PDInputProcessor.modifier) {
            this.mouseZoom = this.zoom(this.mouseZoom);
        } else {
            this.zoom(Math.round(this.mouseZoom));
            this.mouseZoom = GameMath.gate(PixelScene.minZoom, this.mouseZoom, PixelScene.maxZoom);
        }
        return true;
    }

    @Override
    protected void onDrag(NoosaInputProcessor.Touch t) {
        this.camera.target = null;
        if (this.pinching) {
            float curSpan = PointF.distance(this.touch.current, this.another.current);
            if (this.startSpan != 0.0f) {
                this.camera.zoom(GameMath.gate(PixelScene.minZoom, this.startZoom * curSpan / this.startSpan, PixelScene.maxZoom));
            }
        } else if (!this.dragging && PointF.distance(t.current, t.start) > this.dragThreshold) {
            this.dragging = true;
            this.lastPos.set(t.current);
        } else if (this.dragging) {
            this.camera.scroll.offset(PointF.diff(this.lastPos, t.current).invScale(this.camera.zoom));
            this.lastPos.set(t.current);
        }
    }

    public void cancel() {
        if (this.listener != null) {
            this.listener.onSelect(null);
        }
        GameScene.ready();
    }

    public static interface Listener {
        public void onSelect(Integer var1);

        public String prompt();
    }
}

