/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.scenes;

import com.watabou.noosa.BitmapText;
import com.watabou.noosa.Camera;
import com.watabou.noosa.NinePatch;
import com.watabou.noosa.audio.Music;
import com.watabou.pixeldungeon.Badges;
import com.watabou.pixeldungeon.Chrome;
import com.watabou.pixeldungeon.PixelDungeon;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.scenes.TitleScene;
import com.watabou.pixeldungeon.ui.Archs;
import com.watabou.pixeldungeon.ui.BadgesList;
import com.watabou.pixeldungeon.ui.ExitButton;

public class BadgesScene
extends PixelScene {
    private static final String TXT_TITLE = "Your Badges";

    @Override
    public void create() {
        super.create();
        Music.INSTANCE.play("theme.mp3", true);
        Music.INSTANCE.volume(1.0f);
        BadgesScene.uiCamera.visible = false;
        int w = Camera.main.width;
        int h = Camera.main.height;
        Archs archs = new Archs();
        archs.setSize(w, h);
        this.add(archs);
        int pw = Math.min(160, w - 6);
        int ph = h - 30;
        NinePatch panel = Chrome.get(Chrome.Type.WINDOW);
        panel.size(pw, ph);
        panel.x = (w - pw) / 2;
        panel.y = (h - ph) / 2;
        this.add(panel);
        BitmapText title = PixelScene.createText(TXT_TITLE, 9.0f);
        title.hardlight(0xFFFF44);
        title.measure();
        title.x = BadgesScene.align(((float)w - title.width()) / 2.0f);
        title.y = BadgesScene.align((panel.y - title.baseLine()) / 2.0f);
        this.add(title);
        Badges.loadGlobal();
        BadgesList list = new BadgesList(true);
        this.add(list);
        list.setRect(panel.x + (float)panel.marginLeft(), panel.y + (float)panel.marginTop(), panel.innerWidth(), panel.innerHeight());
        ExitButton btnExit = new ExitButton();
        btnExit.setPos((float)Camera.main.width - btnExit.width(), 0.0f);
        this.add(btnExit);
        this.fadeIn();
    }

    @Override
    protected void onBackPressed() {
        PixelDungeon.switchNoFade(TitleScene.class);
    }
}

