/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.scenes;

import com.watabou.noosa.BitmapTextMultiline;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Game;
import com.watabou.noosa.Image;
import com.watabou.noosa.Visual;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.effects.Flare;
import com.watabou.pixeldungeon.effects.Speck;
import com.watabou.pixeldungeon.scenes.InterlevelScene;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.scenes.RankingsScene;
import com.watabou.pixeldungeon.scenes.TitleScene;
import com.watabou.pixeldungeon.ui.RedButton;
import com.watabou.utils.Random;

public class AmuletScene
extends PixelScene {
    private static final String TXT_EXIT = "Let's call it a day";
    private static final String TXT_STAY = "I'm not done yet";
    private static final int WIDTH = 120;
    private static final int BTN_HEIGHT = 18;
    private static final float SMALL_GAP = 2.0f;
    private static final float LARGE_GAP = 8.0f;
    private static final String TXT = "You finally hold it in your hands, the Amulet of Yendor. Using its power you can take over the world or bring peace and prosperity to people or whatever. Anyway, your life will change forever and this game will end here. Or you can stay a mere mortal a little longer.";
    public static boolean noText = false;
    private Image amulet;
    private float timer = 0.0f;

    @Override
    public void create() {
        super.create();
        BitmapTextMultiline text = null;
        if (!noText) {
            text = AmuletScene.createMultiline(TXT, 8.0f);
            text.maxWidth = 120;
            text.measure();
            this.add(text);
        }
        this.amulet = new Image("amulet.png");
        this.add(this.amulet);
        RedButton btnExit = new RedButton(TXT_EXIT){

            @Override
            protected void onClick() {
                Dungeon.win("Obtained the Amulet of Yendor");
                Dungeon.deleteGame(Dungeon.hero.heroClass, true);
                Game.switchScene(noText ? TitleScene.class : RankingsScene.class);
            }
        };
        btnExit.setSize(120.0f, 18.0f);
        this.add(btnExit);
        RedButton btnStay = new RedButton(TXT_STAY){

            @Override
            protected void onClick() {
                AmuletScene.this.onBackPressed();
            }
        };
        btnStay.setSize(120.0f, 18.0f);
        this.add(btnStay);
        if (noText) {
            float height = this.amulet.height + 8.0f + btnExit.height() + 2.0f + btnStay.height();
            this.amulet.x = AmuletScene.align(((float)Camera.main.width - this.amulet.width) / 2.0f);
            this.amulet.y = AmuletScene.align(((float)Camera.main.height - height) / 2.0f);
            btnExit.setPos(((float)Camera.main.width - btnExit.width()) / 2.0f, this.amulet.y + this.amulet.height + 8.0f);
            btnStay.setPos(btnExit.left(), btnExit.bottom() + 2.0f);
        } else {
            float height = this.amulet.height + 8.0f + text.height() + 8.0f + btnExit.height() + 2.0f + btnStay.height();
            this.amulet.x = AmuletScene.align(((float)Camera.main.width - this.amulet.width) / 2.0f);
            this.amulet.y = AmuletScene.align(((float)Camera.main.height - height) / 2.0f);
            text.x = AmuletScene.align(((float)Camera.main.width - text.width()) / 2.0f);
            text.y = this.amulet.y + this.amulet.height + 8.0f;
            btnExit.setPos(((float)Camera.main.width - btnExit.width()) / 2.0f, text.y + text.height() + 8.0f);
            btnStay.setPos(btnExit.left(), btnExit.bottom() + 2.0f);
        }
        new Flare((int)8, (float)48.0f).color((int)0xFFDDBB, (boolean)true).show((Visual)this.amulet, (float)0.0f).angularSpeed = 30.0f;
        this.fadeIn();
    }

    @Override
    protected void onBackPressed() {
        InterlevelScene.mode = InterlevelScene.Mode.CONTINUE;
        Game.switchScene(InterlevelScene.class);
    }

    @Override
    public void update() {
        float f;
        super.update();
        this.timer -= Game.elapsed;
        if (f < 0.0f) {
            this.timer = Random.Float(0.5f, 5.0f);
            Speck star = (Speck)this.recycle(Speck.class);
            star.reset(0, this.amulet.x + 10.5f, this.amulet.y + 5.5f, 101);
            this.add(star);
        }
    }
}

