/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.scenes;

import com.badlogic.gdx.Gdx;
import com.watabou.input.NoosaInputProcessor;
import com.watabou.noosa.BitmapTextMultiline;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Image;
import com.watabou.noosa.TouchArea;
import com.watabou.noosa.Visual;
import com.watabou.pixeldungeon.PixelDungeon;
import com.watabou.pixeldungeon.effects.Flare;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.scenes.TitleScene;
import com.watabou.pixeldungeon.ui.Archs;
import com.watabou.pixeldungeon.ui.ExitButton;
import com.watabou.pixeldungeon.ui.Icons;

public class AboutScene
extends PixelScene {
    private static final String TXT = "Original code & graphics: Watabou\nLibGDX port: Arcnor\nMusic: Cube_Code\n\nThis game is inspired by Brian Walker's Brogue. Try it on Windows, Mac OS or Linux - it's awesome! ;)\n\nPlease visit official website for additional info:";
    private static final String LNK = "pixeldungeon.watabou.ru";

    @Override
    public void create() {
        super.create();
        BitmapTextMultiline text = AboutScene.createMultiline(TXT, 8.0f);
        text.maxWidth = Math.min(Camera.main.width, 120);
        text.measure();
        this.add(text);
        text.x = AboutScene.align(((float)Camera.main.width - text.width()) / 2.0f);
        text.y = AboutScene.align(((float)Camera.main.height - text.height()) / 2.0f);
        BitmapTextMultiline link = AboutScene.createMultiline(LNK, 8.0f);
        link.maxWidth = Math.min(Camera.main.width, 120);
        link.measure();
        link.hardlight(0xFFFF44);
        this.add(link);
        link.x = text.x;
        link.y = text.y + text.height();
        TouchArea hotArea = new TouchArea(link){

            @Override
            protected void onClick(NoosaInputProcessor.Touch touch) {
                Gdx.net.openURI("http://pixeldungeon.watabou.ru");
            }
        };
        this.add(hotArea);
        Image wata = Icons.WATA.get();
        wata.x = AboutScene.align(text.x + (text.width() - wata.width) / 2.0f);
        wata.y = text.y - wata.height - 8.0f;
        this.add(wata);
        new Flare((int)7, (float)64.0f).color((int)0x112233, (boolean)true).show((Visual)wata, (float)0.0f).angularSpeed = 20.0f;
        Archs archs = new Archs();
        archs.setSize(Camera.main.width, Camera.main.height);
        this.addToBack(archs);
        ExitButton btnExit = new ExitButton();
        btnExit.setPos((float)Camera.main.width - btnExit.width(), 0.0f);
        this.add(btnExit);
        this.fadeIn();
    }

    @Override
    protected void onBackPressed() {
        PixelDungeon.switchNoFade(TitleScene.class);
    }
}

