/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.plants;

import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.pixeldungeon.actors.buffs.Poison;
import com.watabou.pixeldungeon.effects.CellEmitter;
import com.watabou.pixeldungeon.effects.particles.PoisonParticle;
import com.watabou.pixeldungeon.items.potions.PotionOfToxicGas;
import com.watabou.pixeldungeon.plants.Plant;

public class Sorrowmoss
extends Plant {
    private static final String TXT_DESC = "A Sorrowmoss is a flower (not a moss) with razor-sharp petals, coated with a deadly venom.";

    public Sorrowmoss() {
        this.image = 2;
        this.plantName = "Sorrowmoss";
    }

    @Override
    public void activate(Char ch) {
        super.activate(ch);
        if (ch != null) {
            Buff.affect(ch, Poison.class).set(Poison.durationFactor(ch) * (float)(4 + Dungeon.depth / 2));
        }
        if (Dungeon.visible[this.pos]) {
            CellEmitter.center(this.pos).burst(PoisonParticle.SPLASH, 3);
        }
    }

    @Override
    public String desc() {
        return TXT_DESC;
    }

    public static class Seed
    extends Plant.Seed {
        public Seed() {
            this.plantName = "Sorrowmoss";
            this.name = "seed of " + this.plantName;
            this.image = 90;
            this.plantClass = Sorrowmoss.class;
            this.alchemyClass = PotionOfToxicGas.class;
        }

        @Override
        public String desc() {
            return Sorrowmoss.TXT_DESC;
        }
    }
}

