/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.mechanics;

import com.watabou.pixeldungeon.levels.Level;
import java.util.Arrays;

public final class ShadowCaster {
    private static final int MAX_DISTANCE = 8;
    private static final int WIDTH = 32;
    private static final int HEIGHT = 32;
    private static int distance;
    private static int[] limits;
    private static boolean[] losBlocking;
    private static boolean[] fieldOfView;
    private static int[][] rounding;
    private static Obstacles obs;

    public static void castShadow(int x, int y, boolean[] fieldOfView, int distance) {
        losBlocking = Level.losBlocking;
        ShadowCaster.distance = distance;
        limits = rounding[distance];
        ShadowCaster.fieldOfView = fieldOfView;
        Arrays.fill(fieldOfView, false);
        fieldOfView[y * 32 + x] = true;
        ShadowCaster.scanSector(x, y, 1, 1, 0, 0);
        ShadowCaster.scanSector(x, y, -1, 1, 0, 0);
        ShadowCaster.scanSector(x, y, 1, -1, 0, 0);
        ShadowCaster.scanSector(x, y, -1, -1, 0, 0);
        ShadowCaster.scanSector(x, y, 0, 0, 1, 1);
        ShadowCaster.scanSector(x, y, 0, 0, -1, 1);
        ShadowCaster.scanSector(x, y, 0, 0, 1, -1);
        ShadowCaster.scanSector(x, y, 0, 0, -1, -1);
    }

    private static void scanSector(int cx, int cy, int m1, int m2, int m3, int m4) {
        obs.reset();
        for (int p = 1; p <= distance; ++p) {
            float dq2 = 0.5f / (float)p;
            int pp = limits[p];
            for (int q = 0; q <= pp; ++q) {
                int x = cx + q * m1 + p * m3;
                int y = cy + p * m2 + q * m4;
                if (y < 0 || y >= 32 || x < 0 || x >= 32) continue;
                float a0 = (float)q / (float)p;
                float a1 = a0 - dq2;
                float a2 = a0 + dq2;
                int pos = y * 32 + x;
                if (!(obs.isBlocked(a0) && obs.isBlocked(a1) && obs.isBlocked(a2))) {
                    ShadowCaster.fieldOfView[pos] = true;
                }
                if (!losBlocking[pos]) continue;
                obs.add(a1, a2);
            }
            obs.nextRow();
        }
    }

    static {
        rounding = new int[9][];
        for (int i = 1; i <= 8; ++i) {
            ShadowCaster.rounding[i] = new int[i + 1];
            for (int j = 1; j <= i; ++j) {
                ShadowCaster.rounding[i][j] = (int)Math.min((long)j, Math.round((double)i * Math.cos(Math.asin((double)j / ((double)i + 0.5)))));
            }
        }
        obs = new Obstacles();
    }

    private static final class Obstacles {
        private static int SIZE = 40;
        private static float[] a1 = new float[SIZE];
        private static float[] a2 = new float[SIZE];
        private int length;
        private int limit;

        private Obstacles() {
        }

        public void reset() {
            this.length = 0;
            this.limit = 0;
        }

        public void add(float o1, float o2) {
            if (this.length > this.limit && o1 <= a2[this.length - 1]) {
                Obstacles.a2[this.length - 1] = o2;
            } else {
                Obstacles.a1[this.length] = o1;
                Obstacles.a2[this.length++] = o2;
            }
        }

        public boolean isBlocked(float a) {
            for (int i = 0; i < this.limit; ++i) {
                if (!(a >= a1[i]) || !(a <= a2[i])) continue;
                return true;
            }
            return false;
        }

        public void nextRow() {
            this.limit = this.length;
        }
    }
}

