/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.levels.traps;

import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.Actor;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.mobs.Bestiary;
import com.watabou.pixeldungeon.actors.mobs.Mob;
import com.watabou.pixeldungeon.items.wands.WandOfBlink;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class SummoningTrap {
    private static final float DELAY = 2.0f;
    private static final Mob DUMMY = new Mob(){};

    public static void trigger(int pos, Char c) {
        if (Dungeon.bossLevel()) {
            return;
        }
        if (c != null) {
            Actor.occupyCell(c);
        }
        int nMobs = 1;
        if (Random.Int(2) == 0) {
            ++nMobs;
            if (Random.Int(2) == 0) {
                ++nMobs;
            }
        }
        ArrayList<Integer> candidates = new ArrayList<Integer>();
        for (int i = 0; i < Level.NEIGHBOURS8.length; ++i) {
            int p = pos + Level.NEIGHBOURS8[i];
            if (Actor.findChar(p) != null || !Level.passable[p] && !Level.avoid[p]) continue;
            candidates.add(p);
        }
        ArrayList respawnPoints = new ArrayList();
        while (nMobs > 0 && candidates.size() > 0) {
            int index = Random.index(candidates);
            SummoningTrap.DUMMY.pos = (Integer)candidates.get(index);
            Actor.occupyCell(DUMMY);
            respawnPoints.add(candidates.remove(index));
            --nMobs;
        }
        for (Integer point : respawnPoints) {
            Mob mob = Bestiary.mob(Dungeon.depth);
            mob.state = mob.WANDERING;
            GameScene.add(mob, 2.0f);
            WandOfBlink.appear(mob, point);
        }
    }
}

