/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.levels.painters;

import com.watabou.pixeldungeon.items.Generator;
import com.watabou.pixeldungeon.items.Heap;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.keys.GoldenKey;
import com.watabou.pixeldungeon.items.keys.IronKey;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.levels.Room;
import com.watabou.pixeldungeon.levels.painters.Painter;
import com.watabou.utils.Random;

public class VaultPainter
extends Painter {
    public static void paint(Level level, Room room) {
        VaultPainter.fill(level, room, 4);
        VaultPainter.fill(level, room, 1, 1);
        int cx = (room.left + room.right) / 2;
        int cy = (room.top + room.bottom) / 2;
        int c = cx + cy * 32;
        switch (Random.Int(3)) {
            case 0: {
                level.drop((Item)VaultPainter.prize((Level)level), (int)c).type = Heap.Type.LOCKED_CHEST;
                level.addItemToSpawn(new GoldenKey());
                break;
            }
            case 1: {
                Item i2;
                Item i1;
                do {
                    i1 = VaultPainter.prize(level);
                    i2 = VaultPainter.prize(level);
                } while (i1.getClass() == i2.getClass());
                level.drop((Item)i1, (int)c).type = Heap.Type.CRYSTAL_CHEST;
                level.drop((Item)i2, (int)(c + Level.NEIGHBOURS8[Random.Int((int)8)])).type = Heap.Type.CRYSTAL_CHEST;
                level.addItemToSpawn(new GoldenKey());
                break;
            }
            case 2: {
                level.drop(VaultPainter.prize(level), c);
                VaultPainter.set(level, c, 11);
            }
        }
        room.entrance().set(Room.Door.Type.LOCKED);
        level.addItemToSpawn(new IronKey());
    }

    private static Item prize(Level level) {
        return Generator.random(Random.oneOf(Generator.Category.WAND, Generator.Category.RING));
    }
}

