/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.levels.painters;

import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.levels.Room;
import com.watabou.pixeldungeon.levels.painters.Painter;
import com.watabou.utils.Point;
import com.watabou.utils.Random;

public class TunnelPainter
extends Painter {
    public static void paint(Level level, Room room) {
        int i;
        int i2;
        int step;
        int to;
        int from;
        int floor = level.tunnelTile();
        Point c = room.center();
        if (room.width() > room.height() || room.width() == room.height() && Random.Int(2) == 0) {
            from = room.right - 1;
            to = room.left + 1;
            for (Room.Door door : room.connected.values()) {
                int n = step = door.y < c.y ? 1 : -1;
                if (door.x == room.left) {
                    from = room.left + 1;
                    for (i2 = door.y; i2 != c.y; i2 += step) {
                        TunnelPainter.set(level, from, i2, floor);
                    }
                    continue;
                }
                if (door.x == room.right) {
                    to = room.right - 1;
                    for (i2 = door.y; i2 != c.y; i2 += step) {
                        TunnelPainter.set(level, to, i2, floor);
                    }
                    continue;
                }
                if (door.x < from) {
                    from = door.x;
                }
                if (door.x > to) {
                    to = door.x;
                }
                for (i2 = door.y + step; i2 != c.y; i2 += step) {
                    TunnelPainter.set(level, door.x, i2, floor);
                }
            }
            for (i = from; i <= to; ++i) {
                TunnelPainter.set(level, i, c.y, floor);
            }
        } else {
            from = room.bottom - 1;
            to = room.top + 1;
            for (Room.Door door : room.connected.values()) {
                int n = step = door.x < c.x ? 1 : -1;
                if (door.y == room.top) {
                    from = room.top + 1;
                    for (i2 = door.x; i2 != c.x; i2 += step) {
                        TunnelPainter.set(level, i2, from, floor);
                    }
                    continue;
                }
                if (door.y == room.bottom) {
                    to = room.bottom - 1;
                    for (i2 = door.x; i2 != c.x; i2 += step) {
                        TunnelPainter.set(level, i2, to, floor);
                    }
                    continue;
                }
                if (door.y < from) {
                    from = door.y;
                }
                if (door.y > to) {
                    to = door.y;
                }
                for (i2 = door.x + step; i2 != c.x; i2 += step) {
                    TunnelPainter.set(level, i2, door.y, floor);
                }
            }
            for (i = from; i <= to; ++i) {
                TunnelPainter.set(level, c.x, i, floor);
            }
        }
        for (Room.Door door : room.connected.values()) {
            door.set(Room.Door.Type.TUNNEL);
        }
    }
}

