/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.levels.painters;

import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.items.Generator;
import com.watabou.pixeldungeon.items.Heap;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.potions.PotionOfLevitation;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.levels.Room;
import com.watabou.pixeldungeon.levels.painters.Painter;
import com.watabou.utils.Random;

public class TrapsPainter
extends Painter {
    public static void paint(Level level, Room room) {
        Integer[] traps = new Integer[]{17, 17, 17, 21, 21, !Dungeon.bossLevel(Dungeon.depth + 1) ? 0 : 39};
        TrapsPainter.fill(level, room, 4);
        TrapsPainter.fill(level, room, 1, Random.element(traps));
        Room.Door door = room.entrance();
        door.set(Room.Door.Type.REGULAR);
        int lastRow = level.map[room.left + 1 + (room.top + 1) * 32] == 0 ? 0 : 1;
        int x = -1;
        int y = -1;
        if (door.x == room.left) {
            x = room.right - 1;
            y = room.top + room.height() / 2;
            TrapsPainter.fill(level, x, room.top + 1, 1, room.height() - 1, lastRow);
        } else if (door.x == room.right) {
            x = room.left + 1;
            y = room.top + room.height() / 2;
            TrapsPainter.fill(level, x, room.top + 1, 1, room.height() - 1, lastRow);
        } else if (door.y == room.top) {
            x = room.left + room.width() / 2;
            y = room.bottom - 1;
            TrapsPainter.fill(level, room.left + 1, y, room.width() - 1, 1, lastRow);
        } else if (door.y == room.bottom) {
            x = room.left + room.width() / 2;
            y = room.top + 1;
            TrapsPainter.fill(level, room.left + 1, y, room.width() - 1, 1, lastRow);
        }
        int pos = x + y * 32;
        if (Random.Int(3) == 0) {
            if (lastRow == 0) {
                TrapsPainter.set(level, pos, 1);
            }
            level.drop((Item)TrapsPainter.prize((Level)level), (int)pos).type = Heap.Type.CHEST;
        } else {
            TrapsPainter.set(level, pos, 11);
            level.drop(TrapsPainter.prize(level), pos);
        }
        level.addItemToSpawn(new PotionOfLevitation());
    }

    private static Item prize(Level level) {
        Item prize = level.itemToSpanAsPrize();
        if (prize != null) {
            return prize;
        }
        prize = Generator.random(Random.oneOf(Generator.Category.WEAPON, Generator.Category.ARMOR));
        for (int i = 0; i < 3; ++i) {
            Item another = Generator.random(Random.oneOf(Generator.Category.WEAPON, Generator.Category.ARMOR));
            if (another.level <= prize.level) continue;
            prize = another;
        }
        return prize;
    }
}

