/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.levels.painters;

import com.watabou.pixeldungeon.items.Generator;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.potions.PotionOfLiquidFlame;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.levels.Room;
import com.watabou.pixeldungeon.levels.painters.Painter;
import com.watabou.utils.Random;

public class StoragePainter
extends Painter {
    public static void paint(Level level, Room room) {
        int floor = 14;
        StoragePainter.fill(level, room, 4);
        StoragePainter.fill(level, room, 1, 14);
        int n = Random.IntRange(3, 4);
        for (int i = 0; i < n; ++i) {
            int pos;
            while (level.map[pos = room.random()] != 14) {
            }
            level.drop(StoragePainter.prize(level), pos);
        }
        room.entrance().set(Room.Door.Type.BARRICADE);
        level.addItemToSpawn(new PotionOfLiquidFlame());
    }

    private static Item prize(Level level) {
        Item prize = level.itemToSpanAsPrize();
        if (prize != null) {
            return prize;
        }
        return Generator.random(Random.oneOf(Generator.Category.POTION, Generator.Category.SCROLL, Generator.Category.FOOD, Generator.Category.GOLD));
    }
}

