/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.levels.painters;

import com.watabou.pixeldungeon.actors.Actor;
import com.watabou.pixeldungeon.actors.mobs.Statue;
import com.watabou.pixeldungeon.items.keys.IronKey;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.levels.Room;
import com.watabou.pixeldungeon.levels.painters.Painter;
import com.watabou.utils.Point;

public class StatuePainter
extends Painter {
    public static void paint(Level level, Room room) {
        StatuePainter.fill(level, room, 4);
        StatuePainter.fill(level, room, 1, 1);
        Point c = room.center();
        int cx = c.x;
        int cy = c.y;
        Room.Door door = room.entrance();
        door.set(Room.Door.Type.LOCKED);
        level.addItemToSpawn(new IronKey());
        if (door.x == room.left) {
            StatuePainter.fill(level, room.right - 1, room.top + 1, 1, room.height() - 1, 35);
            cx = room.right - 2;
        } else if (door.x == room.right) {
            StatuePainter.fill(level, room.left + 1, room.top + 1, 1, room.height() - 1, 35);
            cx = room.left + 2;
        } else if (door.y == room.top) {
            StatuePainter.fill(level, room.left + 1, room.bottom - 1, room.width() - 1, 1, 35);
            cy = room.bottom - 2;
        } else if (door.y == room.bottom) {
            StatuePainter.fill(level, room.left + 1, room.top + 1, room.width() - 1, 1, 35);
            cy = room.top + 2;
        }
        Statue statue = new Statue();
        statue.pos = cx + cy * 32;
        level.mobs.add(statue);
        Actor.occupyCell(statue);
    }
}

