/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.levels.painters;

import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.items.Generator;
import com.watabou.pixeldungeon.items.Gold;
import com.watabou.pixeldungeon.items.Heap;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.levels.Room;
import com.watabou.pixeldungeon.levels.painters.Painter;
import com.watabou.utils.Point;
import com.watabou.utils.Random;

public class StandardPainter
extends Painter {
    public static void paint(Level level, Room room) {
        StandardPainter.fill(level, room, 4);
        for (Room.Door door : room.connected.values()) {
            door.set(Room.Door.Type.REGULAR);
        }
        if (!Dungeon.bossLevel() && Random.Int(5) == 0) {
            switch (Random.Int(6)) {
                case 0: {
                    if (level.feeling != Level.Feeling.GRASS) {
                        if (Math.min(room.width(), room.height()) < 4 || Math.max(room.width(), room.height()) < 6) break;
                        StandardPainter.paintGraveyard(level, room);
                        return;
                    }
                }
                case 1: {
                    if (Dungeon.depth <= 1) break;
                    StandardPainter.paintBurned(level, room);
                    return;
                }
                case 2: {
                    if (Math.max(room.width(), room.height()) < 4) break;
                    StandardPainter.paintStriped(level, room);
                    return;
                }
                case 3: {
                    if (room.width() < 6 || room.height() < 6) break;
                    StandardPainter.paintStudy(level, room);
                    return;
                }
                case 4: {
                    if (level.feeling != Level.Feeling.WATER) {
                        if (room.connected.size() != 2 || room.width() < 4 || room.height() < 4) break;
                        StandardPainter.paintBridge(level, room);
                        return;
                    }
                }
                case 5: {
                    if (Dungeon.bossLevel() || Dungeon.bossLevel(Dungeon.depth + 1) || Math.min(room.width(), room.height()) < 5) break;
                    StandardPainter.paintFissure(level, room);
                    return;
                }
            }
        }
        StandardPainter.fill(level, room, 1, 1);
    }

    private static void paintBurned(Level level, Room room) {
        for (int i = room.top + 1; i < room.bottom; ++i) {
            for (int j = room.left + 1; j < room.right; ++j) {
                int t = 9;
                switch (Random.Int(5)) {
                    case 0: {
                        t = 1;
                        break;
                    }
                    case 1: {
                        t = 19;
                        break;
                    }
                    case 2: {
                        t = 20;
                        break;
                    }
                    case 3: {
                        t = 23;
                    }
                }
                level.map[i * 32 + j] = t;
            }
        }
    }

    private static void paintGraveyard(Level level, Room room) {
        StandardPainter.fill(level, room.left + 1, room.top + 1, room.width() - 1, room.height() - 1, 2);
        int w = room.width() - 1;
        int h = room.height() - 1;
        int nGraves = Math.max(w, h) / 2;
        int index = Random.Int(nGraves);
        int shift = Random.Int(2);
        for (int i = 0; i < nGraves; ++i) {
            int pos = w > h ? room.left + 1 + shift + i * 2 + (room.top + 2 + Random.Int(h - 2)) * 32 : room.left + 2 + Random.Int(w - 2) + (room.top + 1 + shift + i * 2) * 32;
            level.drop((Item)(i == index ? Generator.random() : new Gold()), (int)pos).type = Heap.Type.TOMB;
        }
    }

    private static void paintStriped(Level level, Room room) {
        StandardPainter.fill(level, room.left + 1, room.top + 1, room.width() - 1, room.height() - 1, 14);
        if (room.width() > room.height()) {
            for (int i = room.left + 2; i < room.right; i += 2) {
                StandardPainter.fill(level, i, room.top + 1, 1, room.height() - 1, 15);
            }
        } else {
            for (int i = room.top + 2; i < room.bottom; i += 2) {
                StandardPainter.fill(level, room.left + 1, i, room.width() - 1, 1, 15);
            }
        }
    }

    private static void paintStudy(Level level, Room room) {
        StandardPainter.fill(level, room.left + 1, room.top + 1, room.width() - 1, room.height() - 1, 41);
        StandardPainter.fill(level, room.left + 2, room.top + 2, room.width() - 3, room.height() - 3, 14);
        for (Point point : room.connected.values()) {
            if (point.x == room.left) {
                StandardPainter.set(level, point.x + 1, point.y, 1);
                continue;
            }
            if (point.x == room.right) {
                StandardPainter.set(level, point.x - 1, point.y, 1);
                continue;
            }
            if (point.y == room.top) {
                StandardPainter.set(level, point.x, point.y + 1, 1);
                continue;
            }
            if (point.y != room.bottom) continue;
            StandardPainter.set(level, point.x, point.y - 1, 1);
        }
        StandardPainter.set(level, room.center(), 11);
    }

    private static void paintBridge(Level level, Room room) {
        StandardPainter.fill(level, room.left + 1, room.top + 1, room.width() - 1, room.height() - 1, !Dungeon.bossLevel() && !Dungeon.bossLevel(Dungeon.depth + 1) && Random.Int(3) == 0 ? 0 : 63);
        Point door1 = null;
        Point door2 = null;
        for (Point point : room.connected.values()) {
            if (door1 == null) {
                door1 = point;
                continue;
            }
            door2 = point;
        }
        if (door1.x == room.left && door2.x == room.right || door1.x == room.right && door2.x == room.left) {
            int s = room.width() / 2;
            StandardPainter.drawInside(level, room, door1, s, 14);
            StandardPainter.drawInside(level, room, door2, s, 14);
            StandardPainter.fill(level, room.center().x, Math.min(door1.y, door2.y), 1, Math.abs(door1.y - door2.y) + 1, 14);
        } else if (door1.y == room.top && door2.y == room.bottom || door1.y == room.bottom && door2.y == room.top) {
            int s = room.height() / 2;
            StandardPainter.drawInside(level, room, door1, s, 14);
            StandardPainter.drawInside(level, room, door2, s, 14);
            StandardPainter.fill(level, Math.min(door1.x, door2.x), room.center().y, Math.abs(door1.x - door2.x) + 1, 1, 14);
        } else if (door1.x == door2.x) {
            StandardPainter.fill(level, door1.x == room.left ? room.left + 1 : room.right - 1, Math.min(door1.y, door2.y), 1, Math.abs(door1.y - door2.y) + 1, 14);
        } else if (door1.y == door2.y) {
            StandardPainter.fill(level, Math.min(door1.x, door2.x), door1.y == room.top ? room.top + 1 : room.bottom - 1, Math.abs(door1.x - door2.x) + 1, 1, 14);
        } else if (door1.y == room.top || door1.y == room.bottom) {
            StandardPainter.drawInside(level, room, door1, Math.abs(door1.y - door2.y), 14);
            StandardPainter.drawInside(level, room, door2, Math.abs(door1.x - door2.x), 14);
        } else if (door1.x == room.left || door1.x == room.right) {
            StandardPainter.drawInside(level, room, door1, Math.abs(door1.x - door2.x), 14);
            StandardPainter.drawInside(level, room, door2, Math.abs(door1.y - door2.y), 14);
        }
    }

    private static void paintFissure(Level level, Room room) {
        StandardPainter.fill(level, room.left + 1, room.top + 1, room.width() - 1, room.height() - 1, 1);
        for (int i = room.top + 2; i < room.bottom - 1; ++i) {
            for (int j = room.left + 2; j < room.right - 1; ++j) {
                int h;
                int v = Math.min(i - room.top, room.bottom - i);
                if (Math.min(v, h = Math.min(j - room.left, room.right - j)) <= 2 && Random.Int(2) != 0) continue;
                StandardPainter.set(level, j, i, 0);
            }
        }
    }
}

