/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.levels.painters;

import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.mobs.npcs.ImpShopkeeper;
import com.watabou.pixeldungeon.actors.mobs.npcs.Shopkeeper;
import com.watabou.pixeldungeon.items.Ankh;
import com.watabou.pixeldungeon.items.Generator;
import com.watabou.pixeldungeon.items.Heap;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.Torch;
import com.watabou.pixeldungeon.items.Weightstone;
import com.watabou.pixeldungeon.items.armor.LeatherArmor;
import com.watabou.pixeldungeon.items.armor.MailArmor;
import com.watabou.pixeldungeon.items.armor.PlateArmor;
import com.watabou.pixeldungeon.items.armor.ScaleArmor;
import com.watabou.pixeldungeon.items.bags.ScrollHolder;
import com.watabou.pixeldungeon.items.bags.SeedPouch;
import com.watabou.pixeldungeon.items.bags.WandHolster;
import com.watabou.pixeldungeon.items.food.OverpricedRation;
import com.watabou.pixeldungeon.items.potions.PotionOfHealing;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfIdentify;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfMagicMapping;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfRemoveCurse;
import com.watabou.pixeldungeon.items.weapon.melee.BattleAxe;
import com.watabou.pixeldungeon.items.weapon.melee.Glaive;
import com.watabou.pixeldungeon.items.weapon.melee.Longsword;
import com.watabou.pixeldungeon.items.weapon.melee.Mace;
import com.watabou.pixeldungeon.items.weapon.melee.Quarterstaff;
import com.watabou.pixeldungeon.items.weapon.melee.Spear;
import com.watabou.pixeldungeon.items.weapon.melee.Sword;
import com.watabou.pixeldungeon.items.weapon.melee.WarHammer;
import com.watabou.pixeldungeon.levels.LastShopLevel;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.levels.Room;
import com.watabou.pixeldungeon.levels.painters.Painter;
import com.watabou.utils.Point;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class ShopPainter
extends Painter {
    private static int pasWidth;
    private static int pasHeight;

    public static void paint(Level level, Room room) {
        ShopPainter.fill(level, room, 4);
        ShopPainter.fill(level, room, 1, 14);
        pasWidth = room.width() - 2;
        pasHeight = room.height() - 2;
        int per = pasWidth * 2 + pasHeight * 2;
        Item[] range = ShopPainter.range();
        int pos = ShopPainter.xy2p(room, room.entrance()) + (per - range.length) / 2;
        for (int i = 0; i < range.length; ++i) {
            Point xy = ShopPainter.p2xy(room, (pos + per) % per);
            int cell = xy.x + xy.y * 32;
            if (level.heaps.get(cell) != null) {
                while (level.heaps.get(cell = room.random()) != null) {
                }
            }
            level.drop((Item)range[i], (int)cell).type = Heap.Type.FOR_SALE;
            ++pos;
        }
        ShopPainter.placeShopkeeper(level, room);
        for (Room.Door door : room.connected.values()) {
            door.set(Room.Door.Type.REGULAR);
        }
    }

    private static Item[] range() {
        ArrayList<Item> items = new ArrayList<Item>();
        switch (Dungeon.depth) {
            case 6: {
                items.add((Random.Int(2) == 0 ? new Quarterstaff() : new Spear()).identify());
                items.add(new LeatherArmor().identify());
                items.add(new SeedPouch());
                items.add(new Weightstone());
                break;
            }
            case 11: {
                items.add((Random.Int(2) == 0 ? new Sword() : new Mace()).identify());
                items.add(new MailArmor().identify());
                items.add(new ScrollHolder());
                items.add(new Weightstone());
                break;
            }
            case 16: {
                items.add((Random.Int(2) == 0 ? new Longsword() : new BattleAxe()).identify());
                items.add(new ScaleArmor().identify());
                items.add(new WandHolster());
                items.add(new Weightstone());
                break;
            }
            case 21: {
                switch (Random.Int(3)) {
                    case 0: {
                        items.add(new Glaive().identify());
                        break;
                    }
                    case 1: {
                        items.add(new WarHammer().identify());
                        break;
                    }
                    case 2: {
                        items.add(new PlateArmor().identify());
                    }
                }
                items.add(new Torch());
                items.add(new Torch());
            }
        }
        items.add(new PotionOfHealing());
        for (int i = 0; i < 3; ++i) {
            items.add(Generator.random(Generator.Category.POTION));
        }
        items.add(new ScrollOfIdentify());
        items.add(new ScrollOfRemoveCurse());
        items.add(new ScrollOfMagicMapping());
        items.add(Generator.random(Generator.Category.SCROLL));
        items.add(new OverpricedRation());
        items.add(new OverpricedRation());
        items.add(new Ankh());
        Item[] range = items.toArray(new Item[0]);
        Random.shuffle(range);
        return range;
    }

    private static void placeShopkeeper(Level level, Room room) {
        int pos;
        while (level.heaps.get(pos = room.random()) != null) {
        }
        Shopkeeper shopkeeper = level instanceof LastShopLevel ? new ImpShopkeeper() : new Shopkeeper();
        shopkeeper.pos = pos;
        level.mobs.add(shopkeeper);
        if (level instanceof LastShopLevel) {
            for (int i = 0; i < Level.NEIGHBOURS9.length; ++i) {
                int p = shopkeeper.pos + Level.NEIGHBOURS9[i];
                if (level.map[p] != 14) continue;
                level.map[p] = 63;
            }
        }
    }

    private static int xy2p(Room room, Point xy) {
        if (xy.y == room.top) {
            return xy.x - room.left - 1;
        }
        if (xy.x == room.right) {
            return xy.y - room.top - 1 + pasWidth;
        }
        if (xy.y == room.bottom) {
            return room.right - xy.x - 1 + pasWidth + pasHeight;
        }
        if (xy.y == room.top + 1) {
            return 0;
        }
        return room.bottom - xy.y - 1 + pasWidth * 2 + pasHeight;
    }

    private static Point p2xy(Room room, int p) {
        if (p < pasWidth) {
            return new Point(room.left + 1 + p, room.top + 1);
        }
        if (p < pasWidth + pasHeight) {
            return new Point(room.right - 1, room.top + 1 + (p - pasWidth));
        }
        if (p < pasWidth * 2 + pasHeight) {
            return new Point(room.right - 1 - (p - (pasWidth + pasHeight)), room.bottom - 1);
        }
        return new Point(room.left + 1, room.bottom - 1 - (p - (pasWidth * 2 + pasHeight)));
    }
}

