/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.levels.painters;

import com.watabou.pixeldungeon.actors.mobs.npcs.RatKing;
import com.watabou.pixeldungeon.items.Generator;
import com.watabou.pixeldungeon.items.Gold;
import com.watabou.pixeldungeon.items.Heap;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.weapon.missiles.MissileWeapon;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.levels.Room;
import com.watabou.pixeldungeon.levels.painters.Painter;
import com.watabou.utils.Random;

public class RatKingPainter
extends Painter {
    public static void paint(Level level, Room room) {
        int i;
        RatKingPainter.fill(level, room, 4);
        RatKingPainter.fill(level, room, 1, 14);
        Room.Door entrance = room.entrance();
        entrance.set(Room.Door.Type.HIDDEN);
        int door = entrance.x + entrance.y * 32;
        for (i = room.left + 1; i < room.right; ++i) {
            RatKingPainter.addChest(level, (room.top + 1) * 32 + i, door);
            RatKingPainter.addChest(level, (room.bottom - 1) * 32 + i, door);
        }
        for (i = room.top + 2; i < room.bottom - 1; ++i) {
            RatKingPainter.addChest(level, i * 32 + room.left + 1, door);
            RatKingPainter.addChest(level, i * 32 + room.right - 1, door);
        }
        RatKing king = new RatKing();
        king.pos = room.random(1);
        level.mobs.add(king);
    }

    private static void addChest(Level level, int pos, int door) {
        if (pos == door - 1 || pos == door + 1 || pos == door - 32 || pos == door + 32) {
            return;
        }
        switch (Random.Int(10)) {
            case 0: {
                Item prize = Generator.random(Generator.Category.WEAPON);
                if (prize instanceof MissileWeapon) {
                    prize.quantity(1);
                    break;
                }
                prize.degrade(Random.Int(3));
                break;
            }
            case 1: {
                Item prize = Generator.random(Generator.Category.ARMOR).degrade(Random.Int(3));
                break;
            }
            default: {
                Item prize = new Gold(Random.IntRange(1, 5));
            }
        }
        level.drop((Item)prize, (int)pos).type = Heap.Type.CHEST;
    }
}

