/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.levels.painters;

import com.watabou.pixeldungeon.actors.Actor;
import com.watabou.pixeldungeon.actors.mobs.Piranha;
import com.watabou.pixeldungeon.items.Generator;
import com.watabou.pixeldungeon.items.Heap;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.potions.PotionOfInvisibility;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.levels.Room;
import com.watabou.pixeldungeon.levels.painters.Painter;
import com.watabou.utils.Random;

public class PoolPainter
extends Painter {
    private static final int NPIRANHAS = 3;

    public static void paint(Level level, Room room) {
        PoolPainter.fill(level, room, 4);
        PoolPainter.fill(level, room, 1, 63);
        Room.Door door = room.entrance();
        door.set(Room.Door.Type.REGULAR);
        int x = -1;
        int y = -1;
        if (door.x == room.left) {
            x = room.right - 1;
            y = room.top + room.height() / 2;
        } else if (door.x == room.right) {
            x = room.left + 1;
            y = room.top + room.height() / 2;
        } else if (door.y == room.top) {
            x = room.left + room.width() / 2;
            y = room.bottom - 1;
        } else if (door.y == room.bottom) {
            x = room.left + room.width() / 2;
            y = room.top + 1;
        }
        int pos = x + y * 32;
        level.drop((Item)PoolPainter.prize((Level)level), (int)pos).type = Random.Int(3) == 0 ? Heap.Type.CHEST : Heap.Type.HEAP;
        PoolPainter.set(level, pos, 11);
        level.addItemToSpawn(new PotionOfInvisibility());
        for (int i = 0; i < 3; ++i) {
            Piranha piranha = new Piranha();
            do {
                piranha.pos = room.random();
            } while (level.map[piranha.pos] != 63 || Actor.findChar(piranha.pos) != null);
            level.mobs.add(piranha);
            Actor.occupyCell(piranha);
        }
    }

    private static Item prize(Level level) {
        Item prize = level.itemToSpanAsPrize();
        if (prize != null) {
            return prize;
        }
        prize = Generator.random(Random.oneOf(Generator.Category.WEAPON, Generator.Category.ARMOR));
        for (int i = 0; i < 4; ++i) {
            Item another = Generator.random(Random.oneOf(Generator.Category.WEAPON, Generator.Category.ARMOR));
            if (another.level <= prize.level) continue;
            prize = another;
        }
        return prize;
    }
}

