/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.levels.painters;

import com.watabou.pixeldungeon.items.Generator;
import com.watabou.pixeldungeon.items.Heap;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.keys.IronKey;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.levels.Room;
import com.watabou.pixeldungeon.levels.painters.Painter;
import com.watabou.utils.Point;
import com.watabou.utils.Random;

public class PitPainter
extends Painter {
    public static void paint(Level level, Room room) {
        PitPainter.fill(level, room, 4);
        PitPainter.fill(level, room, 1, 1);
        Room.Door entrance = room.entrance();
        entrance.set(Room.Door.Type.LOCKED);
        Point well = null;
        if (entrance.x == room.left) {
            well = new Point(room.right - 1, Random.Int(2) == 0 ? room.top + 1 : room.bottom - 1);
        } else if (entrance.x == room.right) {
            well = new Point(room.left + 1, Random.Int(2) == 0 ? room.top + 1 : room.bottom - 1);
        } else if (entrance.y == room.top) {
            well = new Point(Random.Int(2) == 0 ? room.left + 1 : room.right - 1, room.bottom - 1);
        } else if (entrance.y == room.bottom) {
            well = new Point(Random.Int(2) == 0 ? room.left + 1 : room.right - 1, room.top + 1);
        }
        PitPainter.set(level, well, 3);
        int remains = room.random();
        while (level.map[remains] == 3) {
            remains = room.random();
        }
        level.drop((Item)new IronKey(), (int)remains).type = Heap.Type.SKELETON;
        if (Random.Int(5) == 0) {
            level.drop(Generator.random(Generator.Category.RING), remains);
        } else {
            level.drop(Generator.random(Random.oneOf(Generator.Category.WEAPON, Generator.Category.ARMOR)), remains);
        }
        int n = Random.IntRange(1, 2);
        for (int i = 0; i < n; ++i) {
            level.drop(PitPainter.prize(level), remains);
        }
    }

    private static Item prize(Level level) {
        Item prize = level.itemToSpanAsPrize();
        if (prize != null) {
            return prize;
        }
        return Generator.random(Random.oneOf(Generator.Category.POTION, Generator.Category.SCROLL, Generator.Category.FOOD, Generator.Category.GOLD));
    }
}

