/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.levels.painters;

import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.levels.Room;
import com.watabou.pixeldungeon.levels.painters.Painter;
import com.watabou.utils.Point;
import java.util.ArrayList;
import java.util.Collections;

public class PassagePainter
extends Painter {
    private static int pasWidth;
    private static int pasHeight;

    public static void paint(Level level, Room room) {
        pasWidth = room.width() - 2;
        pasHeight = room.height() - 2;
        int floor = level.tunnelTile();
        ArrayList<Integer> joints = new ArrayList<Integer>();
        for (Point point : room.connected.values()) {
            joints.add(PassagePainter.xy2p(room, point));
        }
        Collections.sort(joints);
        int nJoints = joints.size();
        int n = pasWidth * 2 + pasHeight * 2;
        int start = 0;
        int maxD = (Integer)joints.get(0) + n - (Integer)joints.get(nJoints - 1);
        for (int i = 1; i < nJoints; ++i) {
            int d = (Integer)joints.get(i) - (Integer)joints.get(i - 1);
            if (d <= maxD) continue;
            maxD = d;
            start = i;
        }
        int end = (start + nJoints - 1) % nJoints;
        int p = (Integer)joints.get(start);
        do {
            PassagePainter.set(level, PassagePainter.p2xy(room, p), floor);
        } while ((p = (p + 1) % n) != (Integer)joints.get(end));
        PassagePainter.set(level, PassagePainter.p2xy(room, p), floor);
        for (Room.Door door : room.connected.values()) {
            door.set(Room.Door.Type.TUNNEL);
        }
    }

    private static int xy2p(Room room, Point xy) {
        if (xy.y == room.top) {
            return xy.x - room.left - 1;
        }
        if (xy.x == room.right) {
            return xy.y - room.top - 1 + pasWidth;
        }
        if (xy.y == room.bottom) {
            return room.right - xy.x - 1 + pasWidth + pasHeight;
        }
        if (xy.y == room.top + 1) {
            return 0;
        }
        return room.bottom - xy.y - 1 + pasWidth * 2 + pasHeight;
    }

    private static Point p2xy(Room room, int p) {
        if (p < pasWidth) {
            return new Point(room.left + 1 + p, room.top + 1);
        }
        if (p < pasWidth + pasHeight) {
            return new Point(room.right - 1, room.top + 1 + (p - pasWidth));
        }
        if (p < pasWidth * 2 + pasHeight) {
            return new Point(room.right - 1 - (p - (pasWidth + pasHeight)), room.bottom - 1);
        }
        return new Point(room.left + 1, room.bottom - 1 - (p - (pasWidth * 2 + pasHeight)));
    }
}

