/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.levels.painters;

import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.levels.Room;
import com.watabou.utils.Point;
import com.watabou.utils.Rect;
import java.util.Arrays;

public class Painter {
    public static void set(Level level, int cell, int value) {
        level.map[cell] = value;
    }

    public static void set(Level level, int x, int y, int value) {
        Painter.set(level, x + y * 32, value);
    }

    public static void set(Level level, Point p, int value) {
        Painter.set(level, p.x, p.y, value);
    }

    public static void fill(Level level, int x, int y, int w, int h, int value) {
        int width = 32;
        int pos = y * width + x;
        int i = y;
        while (i < y + h) {
            Arrays.fill(level.map, pos, pos + w, value);
            ++i;
            pos += width;
        }
    }

    public static void fill(Level level, Rect rect, int value) {
        Painter.fill(level, rect.left, rect.top, rect.width() + 1, rect.height() + 1, value);
    }

    public static void fill(Level level, Rect rect, int m, int value) {
        Painter.fill(level, rect.left + m, rect.top + m, rect.width() + 1 - m * 2, rect.height() + 1 - m * 2, value);
    }

    public static void fill(Level level, Rect rect, int l, int t, int r, int b, int value) {
        Painter.fill(level, rect.left + l, rect.top + t, rect.width() + 1 - (l + r), rect.height() + 1 - (t + b), value);
    }

    public static Point drawInside(Level level, Room room, Point from, int n, int value) {
        Point step = new Point();
        if (from.x == room.left) {
            step.set(1, 0);
        } else if (from.x == room.right) {
            step.set(-1, 0);
        } else if (from.y == room.top) {
            step.set(0, 1);
        } else if (from.y == room.bottom) {
            step.set(0, -1);
        }
        Point p = new Point(from).offset(step);
        for (int i = 0; i < n; ++i) {
            if (value != -1) {
                Painter.set(level, p, value);
            }
            p.offset(step);
        }
        return p;
    }
}

