/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.levels.painters;

import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.blobs.WaterOfAwareness;
import com.watabou.pixeldungeon.actors.blobs.WaterOfHealth;
import com.watabou.pixeldungeon.actors.blobs.WaterOfTransmutation;
import com.watabou.pixeldungeon.actors.blobs.WellWater;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.levels.Room;
import com.watabou.pixeldungeon.levels.painters.Painter;
import com.watabou.utils.Point;
import com.watabou.utils.Random;

public class MagicWellPainter
extends Painter {
    private static final Class<?>[] WATERS = new Class[]{WaterOfAwareness.class, WaterOfHealth.class, WaterOfTransmutation.class};

    public static void paint(Level level, Room room) {
        WellWater water;
        Class<WaterOfTransmutation> waterClass;
        MagicWellPainter.fill(level, room, 4);
        MagicWellPainter.fill(level, room, 1, 1);
        Point c = room.center();
        MagicWellPainter.set(level, c.x, c.y, 34);
        Class clazz = waterClass = Dungeon.depth >= Dungeon.transmutation ? WaterOfTransmutation.class : Random.element(WATERS);
        if (waterClass == WaterOfTransmutation.class) {
            Dungeon.transmutation = Integer.MAX_VALUE;
        }
        if ((water = (WellWater)level.blobs.get(waterClass)) == null) {
            try {
                water = ClassReflection.newInstance(waterClass);
            }
            catch (Exception e) {
                water = null;
            }
        }
        water.seed(c.x + 32 * c.y, 1);
        level.blobs.put(waterClass, water);
        room.entrance().set(Room.Door.Type.REGULAR);
    }
}

