/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.levels.painters;

import com.watabou.pixeldungeon.items.Generator;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.keys.IronKey;
import com.watabou.pixeldungeon.items.scrolls.Scroll;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.levels.Room;
import com.watabou.pixeldungeon.levels.painters.Painter;
import com.watabou.utils.Point;
import com.watabou.utils.Random;

public class LibraryPainter
extends Painter {
    public static void paint(Level level, Room room) {
        LibraryPainter.fill(level, room, 4);
        LibraryPainter.fill(level, room, 1, 1);
        Room.Door entrance = room.entrance();
        Point a = null;
        Point b = null;
        if (entrance.x == room.left) {
            a = new Point(room.left + 1, entrance.y - 1);
            b = new Point(room.left + 1, entrance.y + 1);
            LibraryPainter.fill(level, room.right - 1, room.top + 1, 1, room.height() - 1, 41);
        } else if (entrance.x == room.right) {
            a = new Point(room.right - 1, entrance.y - 1);
            b = new Point(room.right - 1, entrance.y + 1);
            LibraryPainter.fill(level, room.left + 1, room.top + 1, 1, room.height() - 1, 41);
        } else if (entrance.y == room.top) {
            a = new Point(entrance.x + 1, room.top + 1);
            b = new Point(entrance.x - 1, room.top + 1);
            LibraryPainter.fill(level, room.left + 1, room.bottom - 1, room.width() - 1, 1, 41);
        } else if (entrance.y == room.bottom) {
            a = new Point(entrance.x + 1, room.bottom - 1);
            b = new Point(entrance.x - 1, room.bottom - 1);
            LibraryPainter.fill(level, room.left + 1, room.top + 1, room.width() - 1, 1, 41);
        }
        if (a != null && level.map[a.x + a.y * 32] == 1) {
            LibraryPainter.set(level, a, 35);
        }
        if (b != null && level.map[b.x + b.y * 32] == 1) {
            LibraryPainter.set(level, b, 35);
        }
        int n = Random.IntRange(2, 3);
        for (int i = 0; i < n; ++i) {
            int pos;
            while (level.map[pos = room.random()] != 1 || level.heaps.get(pos) != null) {
            }
            level.drop(LibraryPainter.prize(level), pos);
        }
        entrance.set(Room.Door.Type.LOCKED);
        level.addItemToSpawn(new IronKey());
    }

    private static Item prize(Level level) {
        Item prize = level.itemToSpanAsPrize();
        if (prize instanceof Scroll) {
            return prize;
        }
        if (prize != null) {
            level.addItemToSpawn(prize);
        }
        return Generator.random(Generator.Category.SCROLL);
    }
}

