/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.levels.painters;

import com.watabou.pixeldungeon.actors.blobs.Alchemy;
import com.watabou.pixeldungeon.items.Generator;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.keys.IronKey;
import com.watabou.pixeldungeon.items.potions.Potion;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.levels.Room;
import com.watabou.pixeldungeon.levels.painters.Painter;
import com.watabou.utils.Point;
import com.watabou.utils.Random;

public class LaboratoryPainter
extends Painter {
    public static void paint(Level level, Room room) {
        LaboratoryPainter.fill(level, room, 4);
        LaboratoryPainter.fill(level, room, 1, 14);
        Room.Door entrance = room.entrance();
        Point pot = null;
        if (entrance.x == room.left) {
            pot = new Point(room.right - 1, Random.Int(2) == 0 ? room.top + 1 : room.bottom - 1);
        } else if (entrance.x == room.right) {
            pot = new Point(room.left + 1, Random.Int(2) == 0 ? room.top + 1 : room.bottom - 1);
        } else if (entrance.y == room.top) {
            pot = new Point(Random.Int(2) == 0 ? room.left + 1 : room.right - 1, room.bottom - 1);
        } else if (entrance.y == room.bottom) {
            pot = new Point(Random.Int(2) == 0 ? room.left + 1 : room.right - 1, room.top + 1);
        }
        LaboratoryPainter.set(level, pot, 42);
        Alchemy alchemy = new Alchemy();
        alchemy.seed(pot.x + 32 * pot.y, 1);
        level.blobs.put(Alchemy.class, alchemy);
        int n = Random.IntRange(2, 3);
        for (int i = 0; i < n; ++i) {
            int pos;
            while (level.map[pos = room.random()] != 14 || level.heaps.get(pos) != null) {
            }
            level.drop(LaboratoryPainter.prize(level), pos);
        }
        entrance.set(Room.Door.Type.LOCKED);
        level.addItemToSpawn(new IronKey());
    }

    private static Item prize(Level level) {
        Item prize = level.itemToSpanAsPrize();
        if (prize instanceof Potion) {
            return prize;
        }
        if (prize != null) {
            level.addItemToSpawn(prize);
        }
        return Generator.random(Generator.Category.POTION);
    }
}

