/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.levels.painters;

import com.watabou.pixeldungeon.items.Generator;
import com.watabou.pixeldungeon.items.Heap;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.keys.IronKey;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.levels.Room;
import com.watabou.pixeldungeon.levels.painters.Painter;
import com.watabou.utils.Point;

public class CryptPainter
extends Painter {
    public static void paint(Level level, Room room) {
        CryptPainter.fill(level, room, 4);
        CryptPainter.fill(level, room, 1, 1);
        Point c = room.center();
        int cx = c.x;
        int cy = c.y;
        Room.Door entrance = room.entrance();
        entrance.set(Room.Door.Type.LOCKED);
        level.addItemToSpawn(new IronKey());
        if (entrance.x == room.left) {
            CryptPainter.set(level, new Point(room.right - 1, room.top + 1), 35);
            CryptPainter.set(level, new Point(room.right - 1, room.bottom - 1), 35);
            cx = room.right - 2;
        } else if (entrance.x == room.right) {
            CryptPainter.set(level, new Point(room.left + 1, room.top + 1), 35);
            CryptPainter.set(level, new Point(room.left + 1, room.bottom - 1), 35);
            cx = room.left + 2;
        } else if (entrance.y == room.top) {
            CryptPainter.set(level, new Point(room.left + 1, room.bottom - 1), 35);
            CryptPainter.set(level, new Point(room.right - 1, room.bottom - 1), 35);
            cy = room.bottom - 2;
        } else if (entrance.y == room.bottom) {
            CryptPainter.set(level, new Point(room.left + 1, room.top + 1), 35);
            CryptPainter.set(level, new Point(room.right - 1, room.top + 1), 35);
            cy = room.top + 2;
        }
        level.drop((Item)CryptPainter.prize((Level)level), (int)(cx + cy * 32)).type = Heap.Type.TOMB;
    }

    private static Item prize(Level level) {
        Item prize = Generator.random(Generator.Category.ARMOR);
        for (int i = 0; i < 3; ++i) {
            Item another = Generator.random(Generator.Category.ARMOR);
            if (another.level <= prize.level) continue;
            prize = another;
        }
        return prize;
    }
}

