/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.levels.painters;

import com.watabou.pixeldungeon.items.Generator;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.keys.IronKey;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.levels.Room;
import com.watabou.pixeldungeon.levels.painters.Painter;
import com.watabou.utils.Point;
import com.watabou.utils.Random;

public class ArmoryPainter
extends Painter {
    public static void paint(Level level, Room room) {
        ArmoryPainter.fill(level, room, 4);
        ArmoryPainter.fill(level, room, 1, 1);
        Room.Door entrance = room.entrance();
        Point statue = null;
        if (entrance.x == room.left) {
            statue = new Point(room.right - 1, Random.Int(2) == 0 ? room.top + 1 : room.bottom - 1);
        } else if (entrance.x == room.right) {
            statue = new Point(room.left + 1, Random.Int(2) == 0 ? room.top + 1 : room.bottom - 1);
        } else if (entrance.y == room.top) {
            statue = new Point(Random.Int(2) == 0 ? room.left + 1 : room.right - 1, room.bottom - 1);
        } else if (entrance.y == room.bottom) {
            statue = new Point(Random.Int(2) == 0 ? room.left + 1 : room.right - 1, room.top + 1);
        }
        if (statue != null) {
            ArmoryPainter.set(level, statue, 35);
        }
        int n = Random.IntRange(2, 3);
        for (int i = 0; i < n; ++i) {
            int pos;
            while (level.map[pos = room.random()] != 1 || level.heaps.get(pos) != null) {
            }
            level.drop(ArmoryPainter.prize(level), pos);
        }
        entrance.set(Room.Door.Type.LOCKED);
        level.addItemToSpawn(new IronKey());
    }

    private static Item prize(Level level) {
        return Generator.random(Random.oneOf(Generator.Category.ARMOR, Generator.Category.WEAPON));
    }
}

