/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.levels;

import com.watabou.pixeldungeon.PixelDungeon;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.levels.painters.ArmoryPainter;
import com.watabou.pixeldungeon.levels.painters.BlacksmithPainter;
import com.watabou.pixeldungeon.levels.painters.BossExitPainter;
import com.watabou.pixeldungeon.levels.painters.CryptPainter;
import com.watabou.pixeldungeon.levels.painters.EntrancePainter;
import com.watabou.pixeldungeon.levels.painters.ExitPainter;
import com.watabou.pixeldungeon.levels.painters.GardenPainter;
import com.watabou.pixeldungeon.levels.painters.LaboratoryPainter;
import com.watabou.pixeldungeon.levels.painters.LibraryPainter;
import com.watabou.pixeldungeon.levels.painters.MagicWellPainter;
import com.watabou.pixeldungeon.levels.painters.Painter;
import com.watabou.pixeldungeon.levels.painters.PassagePainter;
import com.watabou.pixeldungeon.levels.painters.PitPainter;
import com.watabou.pixeldungeon.levels.painters.PoolPainter;
import com.watabou.pixeldungeon.levels.painters.RatKingPainter;
import com.watabou.pixeldungeon.levels.painters.ShopPainter;
import com.watabou.pixeldungeon.levels.painters.StandardPainter;
import com.watabou.pixeldungeon.levels.painters.StatuePainter;
import com.watabou.pixeldungeon.levels.painters.StoragePainter;
import com.watabou.pixeldungeon.levels.painters.TrapsPainter;
import com.watabou.pixeldungeon.levels.painters.TreasuryPainter;
import com.watabou.pixeldungeon.levels.painters.TunnelPainter;
import com.watabou.pixeldungeon.levels.painters.VaultPainter;
import com.watabou.pixeldungeon.levels.painters.WeakFloorPainter;
import com.watabou.utils.Bundlable;
import com.watabou.utils.Bundle;
import com.watabou.utils.Graph;
import com.watabou.utils.Point;
import com.watabou.utils.Random;
import com.watabou.utils.Rect;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class Room
extends Rect
implements Graph.Node,
Bundlable {
    public HashSet<Room> neigbours = new HashSet();
    public HashMap<Room, Door> connected = new HashMap();
    public int distance;
    public int price = 1;
    public static final ArrayList<Type> SPECIALS = new ArrayList<Type>(Arrays.asList(Type.WEAK_FLOOR, Type.MAGIC_WELL, Type.CRYPT, Type.POOL, Type.GARDEN, Type.LIBRARY, Type.ARMORY, Type.TREASURY, Type.TRAPS, Type.STORAGE, Type.STATUE, Type.LABORATORY, Type.VAULT));
    public Type type = Type.NULL;
    private static final String ROOMS = "rooms";

    public int random() {
        return this.random(0);
    }

    public int random(int m) {
        int x = Random.Int(this.left + 1 + m, this.right - m);
        int y = Random.Int(this.top + 1 + m, this.bottom - m);
        return x + y * 32;
    }

    public void addNeigbour(Room other) {
        Rect i = this.intersect(other);
        if (i.width() == 0 && i.height() >= 3 || i.height() == 0 && i.width() >= 3) {
            this.neigbours.add(other);
            other.neigbours.add(this);
        }
    }

    public void connect(Room room) {
        if (!this.connected.containsKey(room)) {
            this.connected.put(room, null);
            room.connected.put(this, null);
        }
    }

    public Door entrance() {
        return this.connected.values().iterator().next();
    }

    public boolean inside(int p) {
        int x = p % 32;
        int y = p / 32;
        return x > this.left && y > this.top && x < this.right && y < this.bottom;
    }

    public Point center() {
        return new Point((this.left + this.right) / 2 + ((this.right - this.left & 1) == 1 ? Random.Int(2) : 0), (this.top + this.bottom) / 2 + ((this.bottom - this.top & 1) == 1 ? Random.Int(2) : 0));
    }

    @Override
    public int distance() {
        return this.distance;
    }

    @Override
    public void distance(int value) {
        this.distance = value;
    }

    @Override
    public int price() {
        return this.price;
    }

    @Override
    public void price(int value) {
        this.price = value;
    }

    public Collection<Room> edges() {
        return this.neigbours;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        bundle.put("left", this.left);
        bundle.put("top", this.top);
        bundle.put("right", this.right);
        bundle.put("bottom", this.bottom);
        bundle.put("type", this.type.toString());
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        this.left = bundle.getInt("left");
        this.top = bundle.getInt("top");
        this.right = bundle.getInt("right");
        this.bottom = bundle.getInt("bottom");
        this.type = Type.valueOf(bundle.getString("type"));
    }

    public static void shuffleTypes() {
        int size = SPECIALS.size();
        for (int i = 0; i < size - 1; ++i) {
            int j = Random.Int(i, size);
            if (j == i) continue;
            Type t = SPECIALS.get(i);
            SPECIALS.set(i, SPECIALS.get(j));
            SPECIALS.set(j, t);
        }
    }

    public static void useType(Type type) {
        if (SPECIALS.remove((Object)type)) {
            SPECIALS.add(type);
        }
    }

    public static void restoreRoomsFromBundle(Bundle bundle) {
        if (bundle.contains(ROOMS)) {
            SPECIALS.clear();
            for (String type : bundle.getStringArray(ROOMS)) {
                SPECIALS.add(Type.valueOf(type));
            }
        } else {
            Room.shuffleTypes();
        }
    }

    public static void storeRoomsInBundle(Bundle bundle) {
        String[] array = new String[SPECIALS.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = SPECIALS.get(i).toString();
        }
        bundle.put(ROOMS, array);
    }

    public static class Door
    extends Point {
        public Type type = Type.EMPTY;

        public Door(int x, int y) {
            super(x, y);
        }

        public void set(Type type) {
            if (type.compareTo(this.type) > 0) {
                this.type = type;
            }
        }

        public static enum Type {
            EMPTY,
            TUNNEL,
            REGULAR,
            UNLOCKED,
            HIDDEN,
            BARRICADE,
            LOCKED;

        }
    }

    public static enum Type {
        NULL(null),
        STANDARD(StandardPainter.class),
        ENTRANCE(EntrancePainter.class),
        EXIT(ExitPainter.class),
        BOSS_EXIT(BossExitPainter.class),
        TUNNEL(TunnelPainter.class),
        PASSAGE(PassagePainter.class),
        SHOP(ShopPainter.class),
        BLACKSMITH(BlacksmithPainter.class),
        TREASURY(TreasuryPainter.class),
        ARMORY(ArmoryPainter.class),
        LIBRARY(LibraryPainter.class),
        LABORATORY(LaboratoryPainter.class),
        VAULT(VaultPainter.class),
        TRAPS(TrapsPainter.class),
        STORAGE(StoragePainter.class),
        MAGIC_WELL(MagicWellPainter.class),
        GARDEN(GardenPainter.class),
        CRYPT(CryptPainter.class),
        STATUE(StatuePainter.class),
        POOL(PoolPainter.class),
        RAT_KING(RatKingPainter.class),
        WEAK_FLOOR(WeakFloorPainter.class),
        PIT(PitPainter.class);

        private Method paint;

        private Type(Class<? extends Painter> painter) {
            try {
                this.paint = painter.getMethod("paint", Level.class, Room.class);
            }
            catch (Exception e) {
                this.paint = null;
            }
        }

        public void paint(Level level, Room room) {
            try {
                this.paint.invoke(null, level, room);
            }
            catch (Exception e) {
                PixelDungeon.reportException(e);
            }
        }
    }
}

