/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.levels;

import com.watabou.pixeldungeon.Bones;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.Actor;
import com.watabou.pixeldungeon.actors.mobs.Bestiary;
import com.watabou.pixeldungeon.actors.mobs.Mob;
import com.watabou.pixeldungeon.items.Generator;
import com.watabou.pixeldungeon.items.Heap;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfUpgrade;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.levels.Room;
import com.watabou.pixeldungeon.levels.painters.Painter;
import com.watabou.utils.Bundlable;
import com.watabou.utils.Bundle;
import com.watabou.utils.Graph;
import com.watabou.utils.Random;
import com.watabou.utils.Rect;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class RegularLevel
extends Level {
    protected HashSet<Room> rooms;
    protected Room roomEntrance;
    protected Room roomExit;
    protected ArrayList<Room.Type> specials;
    public int secretDoors;
    protected int minRoomSize = 7;
    protected int maxRoomSize = 9;

    @Override
    protected boolean build() {
        if (!this.initRooms()) {
            return false;
        }
        int retry = 0;
        int minDistance = (int)Math.sqrt(this.rooms.size());
        while (true) {
            this.roomEntrance = Random.element(this.rooms);
            if (this.roomEntrance.width() < 4 || this.roomEntrance.height() < 4) continue;
            do {
                this.roomExit = Random.element(this.rooms);
            } while (this.roomExit == this.roomEntrance || this.roomExit.width() < 4 || this.roomExit.height() < 4);
            Graph.buildDistanceMap(this.rooms, this.roomExit);
            int distance = this.roomEntrance.distance();
            if (retry++ > 10) {
                return false;
            }
            if (distance >= minDistance) break;
        }
        this.roomEntrance.type = Room.Type.ENTRANCE;
        this.roomExit.type = Room.Type.EXIT;
        HashSet<Room> connected = new HashSet<Room>();
        connected.add(this.roomEntrance);
        Graph.buildDistanceMap(this.rooms, this.roomExit);
        List<Room> path = Graph.buildPath(this.rooms, this.roomEntrance, this.roomExit);
        Room room = this.roomEntrance;
        for (Room next : path) {
            room.connect(next);
            room = next;
            connected.add(room);
        }
        Graph.setPrice(path, this.roomEntrance.distance);
        Graph.buildDistanceMap(this.rooms, this.roomExit);
        path = Graph.buildPath(this.rooms, this.roomEntrance, this.roomExit);
        room = this.roomEntrance;
        for (Room next : path) {
            room.connect(next);
            room = next;
            connected.add(room);
        }
        int nConnected = (int)((float)this.rooms.size() * Random.Float(0.5f, 0.7f));
        while (connected.size() < nConnected) {
            Room cr = (Room)Random.element(connected);
            Room or = Random.element(cr.neigbours);
            if (connected.contains(or)) continue;
            cr.connect(or);
            connected.add(or);
        }
        if (Dungeon.shopOnLevel()) {
            Room shop = null;
            for (Room r : this.roomEntrance.connected.keySet()) {
                if (r.connected.size() != 1 || r.width() < 5 || r.height() < 5) continue;
                shop = r;
                break;
            }
            if (shop == null) {
                return false;
            }
            shop.type = Room.Type.SHOP;
        }
        this.specials = new ArrayList<Room.Type>(Room.SPECIALS);
        if (Dungeon.bossLevel(Dungeon.depth + 1)) {
            this.specials.remove((Object)Room.Type.WEAK_FLOOR);
        }
        this.assignRoomType();
        this.paint();
        this.paintWater();
        this.paintGrass();
        this.placeTraps();
        return true;
    }

    protected boolean initRooms() {
        this.rooms = new HashSet();
        this.split(new Rect(0, 0, 31, 31));
        if (this.rooms.size() < 8) {
            return false;
        }
        Room[] ra = this.rooms.toArray(new Room[0]);
        for (int i = 0; i < ra.length - 1; ++i) {
            for (int j = i + 1; j < ra.length; ++j) {
                ra[i].addNeigbour(ra[j]);
            }
        }
        return true;
    }

    protected void assignRoomType() {
        int specialRooms = 0;
        for (Room r : this.rooms) {
            if (r.type != Room.Type.NULL || r.connected.size() != 1) continue;
            if (this.specials.size() > 0 && r.width() > 3 && r.height() > 3 && Random.Int(specialRooms * specialRooms + 2) == 0) {
                if (pitRoomNeeded) {
                    r.type = Room.Type.PIT;
                    pitRoomNeeded = false;
                    this.specials.remove((Object)Room.Type.ARMORY);
                    this.specials.remove((Object)Room.Type.CRYPT);
                    this.specials.remove((Object)Room.Type.LABORATORY);
                    this.specials.remove((Object)Room.Type.LIBRARY);
                    this.specials.remove((Object)Room.Type.STATUE);
                    this.specials.remove((Object)Room.Type.TREASURY);
                    this.specials.remove((Object)Room.Type.VAULT);
                    this.specials.remove((Object)Room.Type.WEAK_FLOOR);
                } else if (Dungeon.depth % 5 == 2 && this.specials.contains((Object)Room.Type.LABORATORY)) {
                    r.type = Room.Type.LABORATORY;
                } else if (Dungeon.depth >= Dungeon.transmutation && this.specials.contains((Object)Room.Type.MAGIC_WELL)) {
                    r.type = Room.Type.MAGIC_WELL;
                } else {
                    int n = this.specials.size();
                    r.type = this.specials.get(Math.min(Random.Int(n), Random.Int(n)));
                    if (r.type == Room.Type.WEAK_FLOOR) {
                        weakFloorCreated = true;
                    }
                }
                Room.useType(r.type);
                this.specials.remove((Object)r.type);
                ++specialRooms;
                continue;
            }
            if (Random.Int(2) != 0) continue;
            HashSet<Room> neigbours = new HashSet<Room>();
            for (Room n : r.neigbours) {
                if (r.connected.containsKey(n) || Room.SPECIALS.contains((Object)n.type) || n.type == Room.Type.PIT) continue;
                neigbours.add(n);
            }
            if (neigbours.size() <= 1) continue;
            r.connect((Room)Random.element(neigbours));
        }
        int count = 0;
        for (Room r : this.rooms) {
            int connections;
            if (r.type != Room.Type.NULL || (connections = r.connected.size()) == 0) continue;
            if (Random.Int(connections * connections) == 0) {
                r.type = Room.Type.STANDARD;
                ++count;
                continue;
            }
            r.type = Room.Type.TUNNEL;
        }
        while (count < 4) {
            Room r;
            r = this.randomRoom(Room.Type.TUNNEL, 1);
            if (r == null) continue;
            r.type = Room.Type.STANDARD;
            ++count;
        }
    }

    protected void paintWater() {
        boolean[] lake = this.water();
        for (int i = 0; i < 1024; ++i) {
            if (this.map[i] != 1 || !lake[i]) continue;
            this.map[i] = 63;
        }
    }

    protected void paintGrass() {
        boolean[] grass = this.grass();
        if (this.feeling == Level.Feeling.GRASS) {
            for (Room room : this.rooms) {
                if (room.type == Room.Type.NULL || room.type == Room.Type.PASSAGE || room.type == Room.Type.TUNNEL) continue;
                grass[room.left + 1 + (room.top + 1) * 32] = true;
                grass[room.right - 1 + (room.top + 1) * 32] = true;
                grass[room.left + 1 + (room.bottom - 1) * 32] = true;
                grass[room.right - 1 + (room.bottom - 1) * 32] = true;
            }
        }
        for (int i = 33; i < 991; ++i) {
            if (this.map[i] != 1 || !grass[i]) continue;
            int count = 1;
            for (int n : NEIGHBOURS8) {
                if (!grass[i + n]) continue;
                ++count;
            }
            this.map[i] = Random.Float() < (float)count / 12.0f ? 15 : 2;
        }
    }

    protected abstract boolean[] water();

    protected abstract boolean[] grass();

    protected void placeTraps() {
        int nTraps = this.nTraps();
        float[] trapChances = this.trapChances();
        block10: for (int i = 0; i < nTraps; ++i) {
            int trapPos = Random.Int(1024);
            if (this.map[trapPos] != 1) continue;
            switch (Random.chances(trapChances)) {
                case 0: {
                    this.map[trapPos] = 18;
                    continue block10;
                }
                case 1: {
                    this.map[trapPos] = 20;
                    continue block10;
                }
                case 2: {
                    this.map[trapPos] = 22;
                    continue block10;
                }
                case 3: {
                    this.map[trapPos] = 28;
                    continue block10;
                }
                case 4: {
                    this.map[trapPos] = 31;
                    continue block10;
                }
                case 5: {
                    this.map[trapPos] = 33;
                    continue block10;
                }
                case 6: {
                    this.map[trapPos] = 38;
                    continue block10;
                }
                case 7: {
                    this.map[trapPos] = 40;
                }
            }
        }
    }

    protected int nTraps() {
        return Dungeon.depth <= 1 ? 0 : Random.Int(1, this.rooms.size() + Dungeon.depth);
    }

    protected float[] trapChances() {
        float[] chances = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
        return chances;
    }

    protected void split(Rect rect) {
        int w = rect.width();
        int h = rect.height();
        if (w > this.maxRoomSize && h < this.minRoomSize) {
            int vw = Random.Int(rect.left + 3, rect.right - 3);
            this.split(new Rect(rect.left, rect.top, vw, rect.bottom));
            this.split(new Rect(vw, rect.top, rect.right, rect.bottom));
        } else if (h > this.maxRoomSize && w < this.minRoomSize) {
            int vh = Random.Int(rect.top + 3, rect.bottom - 3);
            this.split(new Rect(rect.left, rect.top, rect.right, vh));
            this.split(new Rect(rect.left, vh, rect.right, rect.bottom));
        } else if (Math.random() <= (double)(this.minRoomSize * this.minRoomSize / rect.square()) && w <= this.maxRoomSize && h <= this.maxRoomSize || w < this.minRoomSize || h < this.minRoomSize) {
            this.rooms.add((Room)new Room().set(rect));
        } else if (Random.Float() < (float)(w - 2) / (float)(w + h - 4)) {
            int vw = Random.Int(rect.left + 3, rect.right - 3);
            this.split(new Rect(rect.left, rect.top, vw, rect.bottom));
            this.split(new Rect(vw, rect.top, rect.right, rect.bottom));
        } else {
            int vh = Random.Int(rect.top + 3, rect.bottom - 3);
            this.split(new Rect(rect.left, rect.top, rect.right, vh));
            this.split(new Rect(rect.left, vh, rect.right, rect.bottom));
        }
    }

    protected void paint() {
        for (Room r : this.rooms) {
            if (r.type != Room.Type.NULL) {
                this.placeDoors(r);
                r.type.paint(this, r);
                continue;
            }
            if (this.feeling != Level.Feeling.CHASM || Random.Int(2) != 0) continue;
            Painter.fill(this, r, 4);
        }
        for (Room r : this.rooms) {
            this.paintDoors(r);
        }
    }

    private void placeDoors(Room r) {
        for (Room n : r.connected.keySet()) {
            Room.Door door = r.connected.get(n);
            if (door != null) continue;
            Rect i = r.intersect(n);
            door = i.width() == 0 ? new Room.Door(i.left, Random.Int(i.top + 1, i.bottom)) : new Room.Door(Random.Int(i.left + 1, i.right), i.top);
            r.connected.put(n, door);
            n.connected.put(r, door);
        }
    }

    protected void paintDoors(Room r) {
        block9: for (Room n : r.connected.keySet()) {
            if (this.joinRooms(r, n)) continue;
            Room.Door d = r.connected.get(n);
            int door = d.x + d.y * 32;
            switch (d.type) {
                case EMPTY: {
                    this.map[door] = 1;
                    break;
                }
                case TUNNEL: {
                    this.map[door] = this.tunnelTile();
                    break;
                }
                case REGULAR: {
                    if (Dungeon.depth <= 1) {
                        this.map[door] = 5;
                        break;
                    }
                    boolean secret = (Dungeon.depth < 6 ? Random.Int(12 - Dungeon.depth) : Random.Int(6)) == 0;
                    int n2 = this.map[door] = secret ? 16 : 5;
                    if (!secret) continue block9;
                    ++this.secretDoors;
                    break;
                }
                case UNLOCKED: {
                    this.map[door] = 5;
                    break;
                }
                case HIDDEN: {
                    this.map[door] = 16;
                    break;
                }
                case BARRICADE: {
                    this.map[door] = Random.Int(3) == 0 ? 41 : 13;
                    break;
                }
                case LOCKED: {
                    this.map[door] = 10;
                }
            }
        }
    }

    protected boolean joinRooms(Room r, Room n) {
        if (r.type != Room.Type.STANDARD || n.type != Room.Type.STANDARD) {
            return false;
        }
        Rect w = r.intersect(n);
        if (w.left == w.right) {
            if (w.bottom - w.top < 3) {
                return false;
            }
            if (w.height() == Math.max(r.height(), n.height())) {
                return false;
            }
            if (r.width() + n.width() > this.maxRoomSize) {
                return false;
            }
            ++w.top;
            w.bottom -= 0;
            ++w.right;
            Painter.fill(this, w.left, w.top, 1, w.height(), 1);
        } else {
            if (w.right - w.left < 3) {
                return false;
            }
            if (w.width() == Math.max(r.width(), n.width())) {
                return false;
            }
            if (r.height() + n.height() > this.maxRoomSize) {
                return false;
            }
            ++w.left;
            w.right -= 0;
            ++w.bottom;
            Painter.fill(this, w.left, w.top, w.width(), 1, 1);
        }
        return true;
    }

    @Override
    public int nMobs() {
        return 2 + Dungeon.depth % 5 + Random.Int(3);
    }

    @Override
    protected void createMobs() {
        int nMobs = this.nMobs();
        for (int i = 0; i < nMobs; ++i) {
            Mob mob = Bestiary.mob(Dungeon.depth);
            do {
                mob.pos = this.randomRespawnCell();
            } while (mob.pos == -1);
            this.mobs.add(mob);
            Actor.occupyCell(mob);
        }
    }

    @Override
    public int randomRespawnCell() {
        Room room;
        int count = 0;
        int cell = -1;
        do {
            if (++count <= 10) continue;
            return -1;
        } while ((room = this.randomRoom(Room.Type.STANDARD, 10)) == null || Dungeon.visible[cell = room.random()] || Actor.findChar(cell) != null || !Level.passable[cell]);
        return cell;
    }

    @Override
    public int randomDestination() {
        Room room;
        int cell = -1;
        while ((room = Random.element(this.rooms)) == null || !Level.passable[cell = room.random()]) {
        }
        return cell;
    }

    @Override
    protected void createItems() {
        int nItems = 3;
        while (Random.Float() < 0.3f) {
            ++nItems;
        }
        for (int i = 0; i < nItems; ++i) {
            Heap.Type type = null;
            switch (Random.Int(20)) {
                case 0: {
                    type = Heap.Type.SKELETON;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    type = Heap.Type.CHEST;
                    break;
                }
                default: {
                    type = Heap.Type.HEAP;
                }
            }
            this.drop((Item)Generator.random(), (int)this.randomDropCell()).type = type;
        }
        for (Item item : this.itemsToSpawn) {
            int cell = this.randomDropCell();
            if (item instanceof ScrollOfUpgrade) {
                while (this.map[cell] == 19 || this.map[cell] == 20) {
                    cell = this.randomDropCell();
                }
            }
            this.drop((Item)item, (int)cell).type = Heap.Type.HEAP;
        }
        Item item = Bones.get();
        if (item != null) {
            this.drop((Item)item, (int)this.randomDropCell()).type = Heap.Type.SKELETON;
        }
    }

    protected Room randomRoom(Room.Type type, int tries) {
        for (int i = 0; i < tries; ++i) {
            Room room = Random.element(this.rooms);
            if (room.type != type) continue;
            return room;
        }
        return null;
    }

    public Room room(int pos) {
        for (Room room : this.rooms) {
            if (room.type == Room.Type.NULL || !room.inside(pos)) continue;
            return room;
        }
        return null;
    }

    protected int randomDropCell() {
        int pos;
        Room room;
        while ((room = this.randomRoom(Room.Type.STANDARD, 1)) == null || !passable[pos = room.random()]) {
        }
        return pos;
    }

    @Override
    public int pitCell() {
        for (Room room : this.rooms) {
            if (room.type != Room.Type.PIT) continue;
            return room.random();
        }
        return super.pitCell();
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put("rooms", this.rooms);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.rooms = new HashSet<Bundlable>(bundle.getCollection("rooms"));
        for (Room r : this.rooms) {
            if (r.type != Room.Type.WEAK_FLOOR) continue;
            weakFloorCreated = true;
            break;
        }
    }
}

