/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.levels;

import com.watabou.pixeldungeon.levels.Level;
import com.watabou.utils.Random;
import java.util.Arrays;

public class DeadEndLevel
extends Level {
    private static final int SIZE = 5;

    public DeadEndLevel() {
        this.color1 = 5459774;
        this.color2 = 12179041;
    }

    @Override
    public String tilesTex() {
        return "tiles2.png";
    }

    @Override
    public String waterTex() {
        return "water4.png";
    }

    @Override
    protected boolean build() {
        int i;
        Arrays.fill(this.map, 4);
        for (i = 2; i < 5; ++i) {
            for (int j = 2; j < 5; ++j) {
                this.map[i * 32 + j] = 1;
            }
        }
        for (i = 1; i <= 5; ++i) {
            this.map[32 * i + 5] = 63;
            this.map[32 * i + 1] = 63;
            this.map[160 + i] = 63;
            this.map[32 + i] = 63;
        }
        this.entrance = 163;
        this.map[this.entrance] = 7;
        this.exit = -1;
        this.map[99] = 29;
        return true;
    }

    @Override
    protected void decorate() {
        for (int i = 0; i < 1024; ++i) {
            if (this.map[i] == 1 && Random.Int(10) == 0) {
                this.map[i] = 24;
                continue;
            }
            if (this.map[i] != 4 || Random.Int(8) != 0) continue;
            this.map[i] = 12;
        }
    }

    @Override
    protected void createMobs() {
    }

    @Override
    protected void createItems() {
    }

    @Override
    public int randomRespawnCell() {
        return -1;
    }
}

