/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.weapon.missiles;

import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.Actor;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.actors.hero.HeroClass;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.weapon.Weapon;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.pixeldungeon.windows.WndOptions;
import java.util.ArrayList;
import net.whitegem.pixeldungeon.LanguageFactory;

public class MissileWeapon
extends Weapon {
    private static final String TXT_MISSILES = "Missile weapon";
    private static final String TXT_YES = "Yes, I know what I'm doing";
    private static final String TXT_NO = "No, I changed my mind";
    private static final String TXT_R_U_SURE = "Do you really want to equip it as a melee weapon?";

    public MissileWeapon() {
        this.stackable = true;
        this.levelKnown = true;
        this.defaultAction = "THROW";
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        if (hero.heroClass != HeroClass.HUNTRESS && hero.heroClass != HeroClass.ROGUE) {
            actions.remove("EQUIP");
            actions.remove("UNEQUIP");
        }
        return actions;
    }

    @Override
    protected void onThrow(int cell) {
        Char enemy = Actor.findChar(cell);
        if (enemy == null || enemy == curUser) {
            super.onThrow(cell);
        } else if (!curUser.shoot(enemy, this)) {
            this.miss(cell);
        }
    }

    protected void miss(int cell) {
        super.onThrow(cell);
    }

    @Override
    public void proc(Char attacker, Char defender, int damage) {
        super.proc(attacker, defender, damage);
        Hero hero = (Hero)attacker;
        if (hero.rangedWeapon == null && this.stackable) {
            if (this.quantity == 1) {
                this.doUnequip(hero, false, false);
            } else {
                this.detach(null);
            }
        }
    }

    @Override
    public boolean doEquip(final Hero hero) {
        GameScene.show(new WndOptions(TXT_MISSILES, TXT_R_U_SURE, new String[]{TXT_YES, TXT_NO}){

            @Override
            protected void onSelect(int index) {
                if (index == 0) {
                    MissileWeapon.super.doEquip(hero);
                }
            }
        });
        return false;
    }

    @Override
    public Item random() {
        return this;
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }

    @Override
    public boolean isIdentified() {
        return true;
    }

    @Override
    public String info() {
        StringBuilder info = new StringBuilder(LanguageFactory.getTranslation(this.desc()));
        info.append("\n\n" + LanguageFactory.getTranslation(Utils.format("Average damage of this weapon equals to %d points per hit. ", this.MIN + (this.MAX - this.MIN) / 2)));
        if (Dungeon.hero.belongings.backpack.items.contains(this)) {
            if (this.STR > Dungeon.hero.STR()) {
                info.append(LanguageFactory.getTranslation(Utils.format("Because of your inadequate strength the accuracy and speed of your attack with this %s is decreased.", this.name)));
            }
            if (this.STR < Dungeon.hero.STR()) {
                info.append(LanguageFactory.getTranslation(Utils.format("Because of your excess strength the damage of your attack with this %s is increased.", this.name)));
            }
        }
        if (this.isEquipped(Dungeon.hero)) {
            info.append("\n\n" + LanguageFactory.getTranslation(Utils.format("You hold the %s at the ready.", this.name)));
        }
        return info.toString();
    }
}

