/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.weapon.missiles;

import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.pixeldungeon.actors.buffs.Cripple;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.weapon.missiles.MissileWeapon;
import com.watabou.utils.Random;

public class Javelin
extends MissileWeapon {
    public Javelin() {
        this(1);
    }

    public Javelin(int number) {
        this.name = "javelin";
        this.image = 110;
        this.STR = 15;
        this.MIN = 2;
        this.MAX = 15;
        this.quantity = number;
    }

    @Override
    public void proc(Char attacker, Char defender, int damage) {
        super.proc(attacker, defender, damage);
        Buff.prolong(defender, Cripple.class, 10.0f);
    }

    @Override
    public String desc() {
        return "This length of metal is weighted to keep the spike at its tip foremost as it sails through the air.";
    }

    @Override
    public Item random() {
        this.quantity = Random.Int(5, 15);
        return this;
    }

    @Override
    public int price() {
        return 15 * this.quantity;
    }
}

