/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.weapon.missiles;

import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.Actor;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.blobs.Blob;
import com.watabou.pixeldungeon.actors.blobs.Fire;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.pixeldungeon.actors.buffs.Burning;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.weapon.missiles.MissileWeapon;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.utils.Random;

public class IncendiaryDart
extends MissileWeapon {
    public IncendiaryDart() {
        this(1);
    }

    public IncendiaryDart(int number) {
        this.name = "incendiary dart";
        this.image = 108;
        this.STR = 12;
        this.MIN = 1;
        this.MAX = 2;
        this.quantity = number;
    }

    @Override
    protected void onThrow(int cell) {
        Char enemy = Actor.findChar(cell);
        if (enemy == null || enemy == curUser) {
            if (Level.flamable[cell]) {
                GameScene.add(Blob.seed(cell, 4, Fire.class));
            } else {
                super.onThrow(cell);
            }
        } else if (!curUser.shoot(enemy, this)) {
            Dungeon.level.drop((Item)this, (int)cell).sprite.drop();
        }
    }

    @Override
    public void proc(Char attacker, Char defender, int damage) {
        Buff.affect(defender, Burning.class).reignite(defender);
        super.proc(attacker, defender, damage);
    }

    @Override
    public String desc() {
        return "The spike on each of these darts is designed to pin it to its target while the unstable compounds strapped to its length burst into brilliant flames.";
    }

    @Override
    public Item random() {
        this.quantity = Random.Int(3, 6);
        return this;
    }

    @Override
    public int price() {
        return 10 * this.quantity;
    }
}

