/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.weapon.missiles;

import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.weapon.Weapon;
import com.watabou.pixeldungeon.items.weapon.enchantments.Piercing;
import com.watabou.pixeldungeon.items.weapon.enchantments.Swing;
import com.watabou.pixeldungeon.items.weapon.missiles.MissileWeapon;
import com.watabou.pixeldungeon.sprites.MissileSprite;

public class Boomerang
extends MissileWeapon {
    private boolean throwEquiped;

    public Boomerang() {
        this.name = "boomerang";
        this.image = 106;
        this.STR = 10;
        this.MIN = 1;
        this.MAX = 4;
        this.stackable = false;
    }

    @Override
    public boolean isUpgradable() {
        return true;
    }

    @Override
    public Item upgrade() {
        return this.upgrade(false);
    }

    @Override
    public Item upgrade(boolean enchant) {
        ++this.MIN;
        this.MAX += 2;
        super.upgrade(enchant);
        this.updateQuickslot();
        return this;
    }

    @Override
    public Item degrade() {
        --this.MIN;
        this.MAX -= 2;
        return super.degrade();
    }

    @Override
    public Weapon enchant(Weapon.Enchantment ench) {
        while (ench instanceof Piercing || ench instanceof Swing) {
            ench = Weapon.Enchantment.random();
        }
        return super.enchant(ench);
    }

    @Override
    public void proc(Char attacker, Char defender, int damage) {
        super.proc(attacker, defender, damage);
        if (attacker instanceof Hero && ((Hero)attacker).rangedWeapon == this) {
            this.circleBack(defender.pos, (Hero)attacker);
        }
    }

    @Override
    protected void miss(int cell) {
        this.circleBack(cell, curUser);
    }

    private void circleBack(int from, Hero owner) {
        ((MissileSprite)Boomerang.curUser.sprite.parent.recycle(MissileSprite.class)).reset(from, Boomerang.curUser.pos, curItem, null);
        if (this.throwEquiped) {
            owner.belongings.weapon = this;
            owner.spend(-1.0f);
        } else if (!this.collect(Boomerang.curUser.belongings.backpack)) {
            Dungeon.level.drop((Item)this, (int)owner.pos).sprite.drop();
        }
    }

    @Override
    public void cast(Hero user, int dst) {
        this.throwEquiped = this.isEquipped(user);
        super.cast(user, dst);
    }

    @Override
    public String desc() {
        return "Thrown to the enemy this flat curved wooden missile will return to the hands of its thrower.";
    }
}

