/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.weapon.melee;

import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.Badges;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfUpgrade;
import com.watabou.pixeldungeon.items.weapon.melee.MeleeWeapon;
import com.watabou.pixeldungeon.items.weapon.missiles.Boomerang;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.pixeldungeon.utils.GLog;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.pixeldungeon.windows.WndBag;
import java.util.ArrayList;

public class ShortSword
extends MeleeWeapon {
    public static final String AC_REFORGE = "REFORGE";
    private static final String TXT_SELECT_WEAPON = "Select a weapon to upgrade";
    private static final String TXT_REFORGED = "you reforged the short sword to upgrade your %s";
    private static final String TXT_NOT_BOOMERANG = "you can't upgrade a boomerang this way";
    private static final float TIME_TO_REFORGE = 2.0f;
    private boolean equipped;
    private final WndBag.Listener itemSelector;

    public ShortSword() {
        super(1, 1.0f, 1.0f);
        this.name = "short sword";
        this.image = 2;
        this.itemSelector = new WndBag.Listener(){

            @Override
            public void onSelect(Item item) {
                if (item != null && !(item instanceof Boomerang)) {
                    Sample.INSTANCE.play("snd_evoke.mp3");
                    ScrollOfUpgrade.upgrade(curUser);
                    Item.evoke(curUser);
                    GLog.w(ShortSword.TXT_REFORGED, item.name());
                    ((MeleeWeapon)item).safeUpgrade();
                    curUser.spendAndNext(2.0f);
                    Badges.validateItemLevelAquired(item);
                } else {
                    if (item instanceof Boomerang) {
                        GLog.w(Utils.format(ShortSword.TXT_NOT_BOOMERANG, new Object[0]), new Object[0]);
                    }
                    if (ShortSword.this.equipped) {
                        curUser.belongings.weapon = ShortSword.this;
                    } else {
                        ShortSword.this.collect(curUser.belongings.backpack);
                    }
                }
            }
        };
        this.STR = 11;
        this.MAX = 12;
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        if (this.level > 0) {
            actions.add(AC_REFORGE);
        }
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        if (action == AC_REFORGE) {
            if (hero.belongings.weapon == this) {
                this.equipped = true;
                hero.belongings.weapon = null;
            } else {
                this.equipped = false;
                this.detach(hero.belongings.backpack);
            }
            curUser = hero;
            GameScene.selectItem(this.itemSelector, WndBag.Mode.WEAPON, TXT_SELECT_WEAPON);
        } else {
            super.execute(hero, action);
        }
    }

    @Override
    public String desc() {
        return "It is indeed quite short, just a few inches longer, than a dagger.";
    }
}

