/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.weapon.melee;

import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.weapon.Weapon;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.utils.Random;
import net.whitegem.pixeldungeon.LanguageFactory;

public class MeleeWeapon
extends Weapon {
    private int tier;

    public MeleeWeapon(int tier, float acu, float dly) {
        this.tier = tier;
        this.ACU = acu;
        this.DLY = dly;
        this.STR = this.typicalSTR();
        this.MIN = this.min();
        this.MAX = this.max();
    }

    private int min() {
        return this.tier;
    }

    private int max() {
        return (int)((float)(this.tier * this.tier - this.tier + 10) / this.ACU * this.DLY);
    }

    @Override
    public Item upgrade() {
        return this.upgrade(false);
    }

    @Override
    public Item upgrade(boolean enchant) {
        --this.STR;
        ++this.MIN;
        this.MAX += this.tier;
        return super.upgrade(enchant);
    }

    public Item safeUpgrade() {
        return this.upgrade(this.enchantment != null);
    }

    @Override
    public Item degrade() {
        ++this.STR;
        --this.MIN;
        this.MAX -= this.tier;
        return super.degrade();
    }

    public int typicalSTR() {
        return 8 + this.tier * 2;
    }

    @Override
    public String info() {
        String p = "\n\n";
        StringBuilder info = new StringBuilder(LanguageFactory.getTranslation(this.desc()));
        String quality = this.levelKnown && this.level != 0 ? (this.level > 0 ? "upgraded" : "degraded") : "";
        info.append("\n\n");
        info.append(LanguageFactory.getTranslation(Utils.format("This %s is %s tier-%d melee weapon. ", this.name, Utils.indefinite(quality), this.tier)));
        if (this.levelKnown) {
            info.append(LanguageFactory.getTranslation(Utils.format("Its average damage is %d points per hit. ", this.MIN + (this.MAX - this.MIN) / 2)));
        } else {
            info.append(LanguageFactory.getTranslation(Utils.format("Its typical average damage is %d points per hit and usually it requires %d points of strength. ", this.min() + (this.max() - this.min()) / 2, this.typicalSTR())));
            if (this.typicalSTR() > Dungeon.hero.STR()) {
                info.append(LanguageFactory.getTranslation("Probably this weapon is too heavy for you. "));
            }
        }
        if (this.DLY != 1.0f) {
            if (this.ACU != 1.0f) {
                if (this.DLY < 1.0f) {
                    if (this.ACU > 1.0f) {
                        info.append(LanguageFactory.getTranslation("This is a rather fast and accurate weapon. "));
                    } else {
                        info.append(LanguageFactory.getTranslation("This is a rather fast but inaccurate weapon. "));
                    }
                } else if (this.ACU > 1.0f) {
                    info.append(LanguageFactory.getTranslation("This is a rather slow but accurate weapon. "));
                } else {
                    info.append(LanguageFactory.getTranslation("This is a rather slow and inaccurate weapon. "));
                }
            } else if (this.DLY < 1.0f) {
                info.append(LanguageFactory.getTranslation("This is a rather fast weapon. "));
            } else {
                info.append(LanguageFactory.getTranslation("This is a rather slow weapon. "));
            }
        } else if (this.ACU != 1.0f) {
            info.append(LanguageFactory.getTranslation("This is a rather " + (this.ACU > 1.0f ? "accurate" : "inaccurate") + " weapon. "));
        }
        switch (this.imbue) {
            case SPEED: {
                info.append(LanguageFactory.getTranslation("It was balanced to make it faster. "));
                break;
            }
            case ACCURACY: {
                info.append(LanguageFactory.getTranslation("It was balanced to make it more accurate. "));
                break;
            }
        }
        if (this.enchantment != null) {
            info.append(LanguageFactory.getTranslation("It is enchanted."));
        }
        if (this.levelKnown && Dungeon.hero.belongings.backpack.items.contains(this)) {
            if (this.STR > Dungeon.hero.STR()) {
                info.append("\n\n");
                info.append(LanguageFactory.getTranslation(Utils.format("Because of your inadequate strength the accuracy and speed of your attack with this %s is decreased.", this.name)));
            }
            if (this.STR < Dungeon.hero.STR()) {
                info.append("\n\n");
                info.append(LanguageFactory.getTranslation(Utils.format("Because of your excess strength the damage of your attack with this %s is increased.", this.name)));
            }
        }
        if (this.isEquipped(Dungeon.hero)) {
            info.append("\n\n");
            if (this.cursed) {
                info.append(LanguageFactory.getTranslation(Utils.format("You hold the %s at the ready, and because it is cursed, you are powerless to let go.", this.name)));
            } else {
                info.append(LanguageFactory.getTranslation(Utils.format("You hold the %s at the ready.", this.name)));
            }
        } else if (this.cursedKnown && this.cursed) {
            info.append("\n\n");
            info.append(LanguageFactory.getTranslation(Utils.format("You can feel a malevolent magic lurking within %s.", this.name)));
        }
        return info.toString();
    }

    @Override
    public int price() {
        int price = 20 * (1 << this.tier - 1);
        if (this.enchantment != null) {
            price = (int)((double)price * 1.5);
        }
        if (this.cursed && this.cursedKnown) {
            price /= 2;
        }
        if (this.levelKnown) {
            if (this.level > 0) {
                price *= this.level + 1;
            } else if (this.level < 0) {
                price /= 1 - this.level;
            }
        }
        if (price < 1) {
            price = 1;
        }
        return price;
    }

    @Override
    public Item random() {
        super.random();
        if (Random.Int(10 + this.level) == 0) {
            this.enchant(Weapon.Enchantment.random());
        }
        return this;
    }
}

