/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.weapon.enchantments;

import com.watabou.pixeldungeon.actors.Actor;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.items.weapon.Weapon;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.utils.Random;

public class Piercing
extends Weapon.Enchantment {
    private static final String TXT_PIERCING = "Piercing %s";

    @Override
    public boolean proc(Weapon weapon, Char attacker, Char defender, int damage) {
        int level = Math.max(0, weapon.level);
        int maxDamage = (int)((double)damage * Math.pow(2.0, -1.0 / (double)(level + 1)));
        if (maxDamage >= 1) {
            Char ch;
            int d = defender.pos - attacker.pos;
            int pos = defender.pos + d;
            while ((ch = Actor.findChar(pos)) != null) {
                int dr = Random.IntRange(0, ch.dr());
                int dmg = Random.Int(1, maxDamage);
                int effectiveDamage = Math.max(dmg - dr, 0);
                ch.damage(effectiveDamage, this);
                ch.sprite.bloodBurstA(attacker.sprite.center(), effectiveDamage);
                ch.sprite.flash();
                if ((pos += d) >= 0 && pos < 1024) continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public String name(String weaponName) {
        return Utils.format(TXT_PIERCING, weaponName);
    }
}

