/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.weapon;

import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.watabou.pixeldungeon.Badges;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.actors.hero.HeroClass;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.KindOfWeapon;
import com.watabou.pixeldungeon.items.weapon.enchantments.Death;
import com.watabou.pixeldungeon.items.weapon.enchantments.Fire;
import com.watabou.pixeldungeon.items.weapon.enchantments.Horror;
import com.watabou.pixeldungeon.items.weapon.enchantments.Instability;
import com.watabou.pixeldungeon.items.weapon.enchantments.Leech;
import com.watabou.pixeldungeon.items.weapon.enchantments.Luck;
import com.watabou.pixeldungeon.items.weapon.enchantments.Paralysis;
import com.watabou.pixeldungeon.items.weapon.enchantments.Piercing;
import com.watabou.pixeldungeon.items.weapon.enchantments.Poison;
import com.watabou.pixeldungeon.items.weapon.enchantments.Slow;
import com.watabou.pixeldungeon.items.weapon.enchantments.Swing;
import com.watabou.pixeldungeon.items.weapon.missiles.MissileWeapon;
import com.watabou.pixeldungeon.sprites.ItemSprite;
import com.watabou.pixeldungeon.utils.GLog;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.utils.Bundlable;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;

public class Weapon
extends KindOfWeapon {
    private static final String TXT_IDENTIFY = "You are now familiar enough with your %s to identify it. It is %s.";
    private static final String TXT_INCOMPATIBLE = "Interaction of different types of magic has negated the enchantment on this weapon!";
    private static final String TXT_TO_STRING = "%s :%d";
    public int STR = 10;
    public float ACU = 1.0f;
    public float DLY = 1.0f;
    public Imbue imbue = Imbue.NONE;
    private int hitsToKnow = 20;
    protected Enchantment enchantment;
    private static final String ENCHANTMENT = "enchantment";
    private static final String IMBUE = "imbue";

    @Override
    public void proc(Char attacker, Char defender, int damage) {
        if (this.enchantment != null) {
            this.enchantment.proc(this, attacker, defender, damage);
        }
        if (!this.levelKnown && --this.hitsToKnow <= 0) {
            this.levelKnown = true;
            GLog.i(Utils.format(TXT_IDENTIFY, this.name(), this.toString()), new Object[0]);
            Badges.validateItemLevelAquired(this);
        }
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(ENCHANTMENT, this.enchantment);
        bundle.put(IMBUE, this.imbue);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.enchantment = (Enchantment)bundle.get(ENCHANTMENT);
        this.imbue = bundle.getEnum(IMBUE, Imbue.class);
    }

    @Override
    public float acuracyFactor(Hero hero) {
        int encumbrance = this.STR - hero.STR();
        if (this instanceof MissileWeapon) {
            switch (hero.heroClass) {
                case WARRIOR: {
                    encumbrance += 3;
                    break;
                }
                case HUNTRESS: {
                    encumbrance -= 2;
                    break;
                }
            }
        }
        return (encumbrance > 0 ? (float)((double)this.ACU / Math.pow(1.5, encumbrance)) : this.ACU) * (this.imbue == Imbue.ACCURACY ? 1.5f : 1.0f);
    }

    @Override
    public float speedFactor(Hero hero) {
        int encumrance = this.STR - hero.STR();
        if (this instanceof MissileWeapon && hero.heroClass == HeroClass.HUNTRESS) {
            encumrance -= 2;
        }
        return (encumrance > 0 ? (float)((double)this.DLY * Math.pow(1.2, encumrance)) : this.DLY) * (this.imbue == Imbue.SPEED ? 0.6f : 1.0f);
    }

    @Override
    public int damageRoll(Hero hero) {
        int exStr;
        int damage = super.damageRoll(hero);
        if (hero.rangedWeapon != null == (hero.heroClass == HeroClass.HUNTRESS) && (exStr = hero.STR() - this.STR) > 0) {
            damage += Random.IntRange(0, exStr);
        }
        return damage;
    }

    public Item upgrade(boolean enchant) {
        if (this.enchantment != null) {
            if (!enchant && Random.Int(this.level) > 0) {
                GLog.w(TXT_INCOMPATIBLE, new Object[0]);
                this.enchant(null);
            }
        } else if (enchant) {
            this.enchant(Enchantment.random());
        }
        return super.upgrade();
    }

    @Override
    public String toString() {
        return this.levelKnown ? Utils.format(TXT_TO_STRING, super.toString(), this.STR) : super.toString();
    }

    @Override
    public String name() {
        return this.enchantment == null ? super.name() : this.enchantment.name(super.name());
    }

    @Override
    public Item random() {
        if ((double)Random.Float() < 0.4) {
            int n = 1;
            if (Random.Int(3) == 0) {
                ++n;
                if (Random.Int(3) == 0) {
                    ++n;
                }
            }
            if (Random.Int(2) == 0) {
                this.upgrade(n);
            } else {
                this.degrade(n);
                this.cursed = true;
            }
        }
        return this;
    }

    public Weapon enchant(Enchantment ench) {
        this.enchantment = ench;
        return this;
    }

    public boolean isEnchanted() {
        return this.enchantment != null;
    }

    @Override
    public ItemSprite.Glowing glowing() {
        return this.enchantment != null ? this.enchantment.glowing() : null;
    }

    public static abstract class Enchantment
    implements Bundlable {
        private static final Class<?>[] enchants = new Class[]{Fire.class, Poison.class, Death.class, Paralysis.class, Leech.class, Slow.class, Swing.class, Piercing.class, Instability.class, Horror.class, Luck.class};
        private static final float[] chances = new float[]{10.0f, 10.0f, 1.0f, 2.0f, 1.0f, 2.0f, 3.0f, 3.0f, 3.0f, 2.0f, 2.0f};

        public abstract boolean proc(Weapon var1, Char var2, Char var3, int var4);

        public String name(String weaponName) {
            return weaponName;
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
        }

        @Override
        public void storeInBundle(Bundle bundle) {
        }

        public ItemSprite.Glowing glowing() {
            return ItemSprite.Glowing.WHITE;
        }

        public static Enchantment random() {
            try {
                return (Enchantment)ClassReflection.newInstance(enchants[Random.chances(chances)]);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static enum Imbue {
        NONE,
        SPEED,
        ACCURACY;

    }
}

