/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.wands;

import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.Actor;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.effects.MagicMissile;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfTeleportation;
import com.watabou.pixeldungeon.items.wands.Wand;
import com.watabou.pixeldungeon.utils.GLog;
import com.watabou.utils.Callback;

public class WandOfTeleportation
extends Wand {
    private static final String TELEPORT_WAND_TEXT_0 = " teleported ";
    private static final String TELEPORT_WAND_TEXT_1 = " to somewhere";

    public WandOfTeleportation() {
        this.name = "Wand of Teleportation";
    }

    @Override
    protected void onZap(int cell) {
        Char ch = Actor.findChar(cell);
        if (ch == curUser) {
            this.setKnown();
            ScrollOfTeleportation.teleportHero(curUser);
        } else if (ch != null) {
            int pos;
            int count = 10;
            do {
                pos = Dungeon.level.randomRespawnCell();
            } while (count-- > 0 && pos == -1);
            if (pos == -1) {
                GLog.w("Strong magic aura of this place prevents you from teleporting!", new Object[0]);
            } else {
                ch.pos = pos;
                ch.sprite.place(ch.pos);
                ch.sprite.visible = Dungeon.visible[pos];
                GLog.i("%s teleported %s to somewhere", WandOfTeleportation.curUser.name, ch.name);
            }
        } else {
            GLog.i("nothing happened", new Object[0]);
        }
    }

    @Override
    protected void fx(int cell, Callback callback) {
        MagicMissile.coldLight(WandOfTeleportation.curUser.sprite.parent, WandOfTeleportation.curUser.pos, cell, callback);
        Sample.INSTANCE.play("snd_zap.mp3");
    }

    @Override
    public String desc() {
        return "A blast from this wand will teleport a creature against its will to a random place on the current level.";
    }
}

