/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.wands;

import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.Actor;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.mobs.Mob;
import com.watabou.pixeldungeon.effects.MagicMissile;
import com.watabou.pixeldungeon.effects.Pushing;
import com.watabou.pixeldungeon.items.Dewdrop;
import com.watabou.pixeldungeon.items.Heap;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.potions.PotionOfStrength;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfUpgrade;
import com.watabou.pixeldungeon.items.wands.Wand;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.mechanics.Ballistica;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.pixeldungeon.utils.GLog;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.utils.Callback;

public class WandOfTelekinesis
extends Wand {
    private static final String TXT_YOU_NOW_HAVE = "You have magically transported %s into your backpack";

    public WandOfTelekinesis() {
        this.name = "Wand of Telekinesis";
        this.hitChars = false;
    }

    @Override
    protected void onZap(int cell) {
        boolean mapUpdated = false;
        int maxDistance = this.level() + 4;
        Ballistica.distance = Math.min(Ballistica.distance, maxDistance);
        Heap heap = null;
        for (int i = 1; i < Ballistica.distance; ++i) {
            int c = Ballistica.trace[i];
            int before = Dungeon.level.map[c];
            Char ch = Actor.findChar(c);
            if (ch != null) {
                if (i == Ballistica.distance - 1) {
                    ch.damage(maxDistance - 1 - i, this);
                } else {
                    int next = Ballistica.trace[i + 1];
                    if ((Level.passable[next] || Level.avoid[next]) && Actor.findChar(next) == null) {
                        Actor.addDelayed(new Pushing(ch, ch.pos, next), -1.0f);
                        ch.pos = next;
                        Actor.freeCell(next);
                        if (ch instanceof Mob) {
                            Dungeon.level.mobPress((Mob)ch);
                        } else {
                            Dungeon.level.press(ch.pos, ch);
                        }
                    } else {
                        ch.damage(maxDistance - 1 - i, this);
                    }
                }
            }
            if (heap == null && (heap = (Heap)Dungeon.level.heaps.get(c)) != null) {
                switch (heap.type) {
                    case HEAP: {
                        this.transport(heap);
                        break;
                    }
                    case CHEST: {
                        this.open(heap);
                        break;
                    }
                }
            }
            Dungeon.level.press(c, null);
            if (before == 6 && Actor.findChar(c) == null) {
                Level.set(c, 5);
                GameScene.updateMap(c);
            } else if (Level.water[c]) {
                GameScene.ripple(c);
            }
            if (mapUpdated || Dungeon.level.map[c] == before) continue;
            mapUpdated = true;
        }
        if (mapUpdated) {
            Dungeon.observe();
        }
    }

    private void transport(Heap heap) {
        Item item = heap.pickUp();
        if (item.doPickUp(curUser)) {
            if (!(item instanceof Dewdrop)) {
                if (item instanceof ScrollOfUpgrade && ((ScrollOfUpgrade)item).isKnown() || item instanceof PotionOfStrength && ((PotionOfStrength)item).isKnown()) {
                    GLog.p(Utils.format(TXT_YOU_NOW_HAVE, item.name()), new Object[0]);
                } else {
                    GLog.i(TXT_YOU_NOW_HAVE, item.name());
                }
            }
        } else {
            Dungeon.level.drop((Item)item, (int)WandOfTelekinesis.curUser.pos).sprite.drop();
        }
    }

    private void open(Heap heap) {
        heap.type = Heap.Type.HEAP;
        heap.sprite.link();
        heap.sprite.drop();
    }

    @Override
    protected void fx(int cell, Callback callback) {
        MagicMissile.force(WandOfTelekinesis.curUser.sprite.parent, WandOfTelekinesis.curUser.pos, cell, callback);
        Sample.INSTANCE.play("snd_zap.mp3");
    }

    @Override
    public String desc() {
        return "Waves of magic force from this wand will affect all cells on their way triggering traps, trampling high vegetation, opening closed doors and closing open ones. They also push back monsters.";
    }
}

