/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.wands;

import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.Actor;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.mobs.npcs.NPC;
import com.watabou.pixeldungeon.effects.CellEmitter;
import com.watabou.pixeldungeon.effects.MagicMissile;
import com.watabou.pixeldungeon.effects.Speck;
import com.watabou.pixeldungeon.items.wands.Wand;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.mechanics.Ballistica;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.pixeldungeon.sprites.SheepSprite;
import com.watabou.pixeldungeon.utils.BArray;
import com.watabou.utils.Callback;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;

public class WandOfFlock
extends Wand {
    public WandOfFlock() {
        this.name = "Wand of Flock";
    }

    @Override
    protected void onZap(int cell) {
        int level = this.level();
        int n = level + 2;
        if (Actor.findChar(cell) != null && Ballistica.distance > 2) {
            cell = Ballistica.trace[Ballistica.distance - 2];
        }
        boolean[] passable = BArray.or(Level.passable, Level.avoid, null);
        for (Actor actor : Actor.all()) {
            if (!(actor instanceof Char)) continue;
            passable[((Char)actor).pos] = false;
        }
        PathFinder.buildDistanceMap(cell, passable, n);
        int dist = 0;
        if (Actor.findChar(cell) != null) {
            PathFinder.distance[cell] = Integer.MAX_VALUE;
            dist = 1;
        }
        float lifespan = level + 3;
        block1: for (int i = 0; i < n; ++i) {
            do {
                for (int j = 0; j < 1024; ++j) {
                    if (PathFinder.distance[j] != dist) continue;
                    Sheep sheep = new Sheep();
                    sheep.lifespan = lifespan;
                    sheep.pos = j;
                    GameScene.add(sheep);
                    Dungeon.level.mobPress(sheep);
                    CellEmitter.get(j).burst(Speck.factory(7), 4);
                    PathFinder.distance[j] = Integer.MAX_VALUE;
                    continue block1;
                }
            } while (++dist < n);
        }
    }

    @Override
    protected void fx(int cell, Callback callback) {
        MagicMissile.wool(WandOfFlock.curUser.sprite.parent, WandOfFlock.curUser.pos, cell, callback);
        Sample.INSTANCE.play("snd_zap.mp3");
    }

    @Override
    public String desc() {
        return "A flick of this wand summons a flock of magic sheep, creating temporary impenetrable obstacle.";
    }

    public static class Sheep
    extends NPC {
        private static final String[] QUOTES = new String[]{"Baa!", "Baa?", "Baa.", "Baa..."};
        public float lifespan;
        private boolean initialized;

        public Sheep() {
            this.name = "sheep";
            this.spriteClass = SheepSprite.class;
            this.initialized = false;
        }

        @Override
        protected boolean act() {
            if (this.initialized) {
                this.HP = 0;
                this.destroy();
                this.sprite.die();
            } else {
                this.initialized = true;
                this.spend(this.lifespan + Random.Float(2.0f));
            }
            return true;
        }

        @Override
        public void damage(int dmg, Object src) {
        }

        @Override
        public String description() {
            return "This is a magic sheep. What's so magical about it? You can't kill it. It will stand there until it magcially fades away, all the while chewing cud with a blank stare.";
        }

        @Override
        public void interact() {
            this.yell(Random.element(QUOTES));
        }
    }
}

