/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.wands;

import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.Actor;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.blobs.Blob;
import com.watabou.pixeldungeon.actors.blobs.Fire;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.pixeldungeon.actors.buffs.Burning;
import com.watabou.pixeldungeon.effects.MagicMissile;
import com.watabou.pixeldungeon.effects.particles.FlameParticle;
import com.watabou.pixeldungeon.items.wands.Wand;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.mechanics.Ballistica;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.pixeldungeon.utils.GLog;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.utils.Callback;
import com.watabou.utils.Random;

public class WandOfFirebolt
extends Wand {
    public WandOfFirebolt() {
        this.name = "Wand of Firebolt";
    }

    @Override
    protected void onZap(int cell) {
        int level = this.level();
        for (int i = 1; i < Ballistica.distance - 1; ++i) {
            int c = Ballistica.trace[i];
            if (!Level.flamable[c]) continue;
            GameScene.add(Blob.seed(c, 1, Fire.class));
        }
        GameScene.add(Blob.seed(cell, 1, Fire.class));
        Char ch = Actor.findChar(cell);
        if (ch != null) {
            ch.damage(Random.Int(1, 8 + level * level), this);
            Buff.affect(ch, Burning.class).reignite(ch);
            ch.sprite.emitter().burst(FlameParticle.FACTORY, 5);
            if (ch == curUser && !ch.isAlive()) {
                Dungeon.fail(Utils.format("Killed by your own %s on level %d", this.name, Dungeon.depth));
                GLog.n("You killed yourself with your own Wand of Firebolt...", new Object[0]);
            }
        }
    }

    @Override
    protected void fx(int cell, Callback callback) {
        MagicMissile.fire(WandOfFirebolt.curUser.sprite.parent, WandOfFirebolt.curUser.pos, cell, callback);
        Sample.INSTANCE.play("snd_zap.mp3");
    }

    @Override
    public String desc() {
        return "This wand unleashes bursts of magical fire. It will ignite flammable terrain, and will damage and burn a creature it hits.";
    }
}

