/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.wands;

import com.watabou.noosa.Camera;
import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.Actor;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.pixeldungeon.actors.buffs.Paralysis;
import com.watabou.pixeldungeon.effects.CellEmitter;
import com.watabou.pixeldungeon.effects.MagicMissile;
import com.watabou.pixeldungeon.effects.Speck;
import com.watabou.pixeldungeon.items.wands.Wand;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.mechanics.Ballistica;
import com.watabou.pixeldungeon.utils.BArray;
import com.watabou.pixeldungeon.utils.GLog;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.utils.Callback;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;

public class WandOfAvalanche
extends Wand {
    public WandOfAvalanche() {
        this.name = "Wand of Avalanche";
        this.hitChars = false;
    }

    @Override
    protected void onZap(int cell) {
        Sample.INSTANCE.play("snd_rocks.mp3");
        int level = this.level();
        Ballistica.distance = Math.min(Ballistica.distance, 8 + level);
        int size = 1 + level / 3;
        PathFinder.buildDistanceMap(cell, BArray.not(Level.solid, null), size);
        for (int i = 0; i < 1024; ++i) {
            int d = PathFinder.distance[i];
            if (d >= Integer.MAX_VALUE) continue;
            Char ch = Actor.findChar(i);
            if (ch != null) {
                ch.sprite.flash();
                ch.damage(Random.Int(2, 6 + (size - d) * 2), this);
                if (ch.isAlive() && Random.Int(2 + d) == 0) {
                    Buff.prolong(ch, Paralysis.class, Random.IntRange(2, 6));
                }
            }
            CellEmitter.get(i).start(Speck.factory(8), 0.07f, 3 + (size - d));
            Camera.main.shake(3.0f, 0.07f * (float)(3 + (size - d)));
        }
        if (!curUser.isAlive()) {
            Dungeon.fail(Utils.format("Killed by your own %s on level %d", this.name, Dungeon.depth));
            GLog.n("You killed yourself with your own Wand of Avalanche...", new Object[0]);
        }
    }

    @Override
    protected void fx(int cell, Callback callback) {
        MagicMissile.earth(WandOfAvalanche.curUser.sprite.parent, WandOfAvalanche.curUser.pos, cell, callback);
        Sample.INSTANCE.play("snd_zap.mp3");
    }

    @Override
    public String desc() {
        return "When a discharge of this wand hits a wall (or any other solid obstacle) it causes an avalanche of stones, damaging and stunning all creatures in the affected area.";
    }
}

