/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.wands;

import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.Badges;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.Actor;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.pixeldungeon.actors.buffs.Invisibility;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.actors.hero.HeroClass;
import com.watabou.pixeldungeon.effects.MagicMissile;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.ItemStatusHandler;
import com.watabou.pixeldungeon.items.KindOfWeapon;
import com.watabou.pixeldungeon.items.bags.Bag;
import com.watabou.pixeldungeon.items.rings.RingOfPower;
import com.watabou.pixeldungeon.items.wands.WandOfAmok;
import com.watabou.pixeldungeon.items.wands.WandOfAvalanche;
import com.watabou.pixeldungeon.items.wands.WandOfBlink;
import com.watabou.pixeldungeon.items.wands.WandOfDisintegration;
import com.watabou.pixeldungeon.items.wands.WandOfFirebolt;
import com.watabou.pixeldungeon.items.wands.WandOfFlock;
import com.watabou.pixeldungeon.items.wands.WandOfLightning;
import com.watabou.pixeldungeon.items.wands.WandOfPoison;
import com.watabou.pixeldungeon.items.wands.WandOfRegrowth;
import com.watabou.pixeldungeon.items.wands.WandOfSlowness;
import com.watabou.pixeldungeon.items.wands.WandOfTelekinesis;
import com.watabou.pixeldungeon.items.wands.WandOfTeleportation;
import com.watabou.pixeldungeon.mechanics.Ballistica;
import com.watabou.pixeldungeon.scenes.CellSelector;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.pixeldungeon.ui.QuickSlot;
import com.watabou.pixeldungeon.utils.GLog;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.utils.Bundle;
import com.watabou.utils.Callback;
import com.watabou.utils.Random;
import java.util.ArrayList;
import net.whitegem.pixeldungeon.LanguageFactory;

public abstract class Wand
extends KindOfWeapon {
    public static final String AC_ZAP = "ZAP";
    private static final String TXT_WOOD = "This thin %s wand is warm to the touch. Who knows what it will do when used?";
    private static final String TXT_DAMAGE = "When this wand is used as a melee weapon, its average damage is %d points per hit.";
    private static final String TXT_WEAPON = "You can use this wand as a melee weapon.";
    private static final String TXT_FIZZLES = "your wand fizzles; it must be out of charges for now";
    private static final String TXT_SELF_TARGET = "You can't target yourself";
    private static final float TIME_TO_ZAP = 1.0f;
    public int maxCharges;
    public int curCharges;
    protected Charger charger;
    private boolean curChargeKnown;
    protected boolean hitChars;
    private static final Class<?>[] wands = new Class[]{WandOfTeleportation.class, WandOfSlowness.class, WandOfFirebolt.class, WandOfPoison.class, WandOfRegrowth.class, WandOfBlink.class, WandOfLightning.class, WandOfAmok.class, WandOfTelekinesis.class, WandOfFlock.class, WandOfDisintegration.class, WandOfAvalanche.class};
    private static final String[] woods = new String[]{"holly", "yew", "ebony", "cherry", "teak", "rowan", "willow", "mahogany", "bamboo", "purpleheart", "oak", "birch"};
    private static final Integer[] images = new Integer[]{48, 49, 50, 51, 52, 53, 54, 55, 68, 69, 70, 71};
    private static ItemStatusHandler<Wand> handler;
    private String wood;
    private static final String MAX_CHARGES = "maxCharges";
    private static final String CUR_CHARGES = "curCharges";
    private static final String CUR_CHARGE_KNOWN = "curChargeKnown";
    protected static CellSelector.Listener zapper;

    public static void initWoods() {
        handler = new ItemStatusHandler(wands, woods, images);
    }

    public static void save(Bundle bundle) {
        handler.save(bundle);
    }

    public static void restore(Bundle bundle) {
        handler = new ItemStatusHandler(wands, woods, images, bundle);
    }

    public Wand() {
        this.curCharges = this.maxCharges = this.initialCharges();
        this.curChargeKnown = false;
        this.hitChars = true;
        this.defaultAction = AC_ZAP;
        this.calculateDamage();
        try {
            this.image = handler.image(this);
            this.wood = handler.label(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        if (this.curCharges > 0 || !this.curChargeKnown) {
            actions.add(AC_ZAP);
        }
        if (hero.heroClass != HeroClass.MAGE) {
            actions.remove("EQUIP");
            actions.remove("UNEQUIP");
        }
        return actions;
    }

    @Override
    public boolean doUnequip(Hero hero, boolean collect, boolean single) {
        this.onDetach();
        return super.doUnequip(hero, collect, single);
    }

    @Override
    public void activate(Hero hero) {
        this.charge(hero);
    }

    @Override
    public void execute(Hero hero, String action) {
        if (action.equals(AC_ZAP)) {
            curUser = hero;
            curItem = this;
            GameScene.selectCell(zapper);
        } else {
            super.execute(hero, action);
        }
    }

    protected abstract void onZap(int var1);

    @Override
    public boolean collect(Bag container) {
        if (super.collect(container)) {
            if (container.owner != null) {
                this.charge(container.owner);
            }
            return true;
        }
        return false;
    }

    public void charge(Char owner) {
        this.charger = new Charger();
        this.charger.attachTo(owner);
    }

    @Override
    public void onDetach() {
        this.stopCharging();
    }

    public void stopCharging() {
        if (this.charger != null) {
            this.charger.detach();
            this.charger = null;
        }
    }

    public int level() {
        if (this.charger != null) {
            RingOfPower.Power power = this.charger.target.buff(RingOfPower.Power.class);
            return power == null ? this.level : Math.max(this.level + power.level, 0);
        }
        return this.level;
    }

    protected boolean isKnown() {
        return handler.isKnown(this);
    }

    public void setKnown() {
        if (!this.isKnown()) {
            handler.know(this);
        }
        Badges.validateAllWandsIdentified();
    }

    @Override
    public Item identify() {
        this.setKnown();
        this.curChargeKnown = true;
        super.identify();
        this.updateQuickslot();
        return this;
    }

    @Override
    public String toString() {
        String status = this.status();
        if (status != null) {
            return Utils.format("%s %s", super.toString(), "(" + status + ")");
        }
        return super.toString();
    }

    @Override
    public String name() {
        return this.isKnown() ? this.name : Utils.format("%s wand", this.wood);
    }

    @Override
    public String info() {
        StringBuilder info = new StringBuilder(this.isKnown() ? LanguageFactory.getTranslation(this.desc()) : LanguageFactory.getTranslation(Utils.format(TXT_WOOD, this.wood)));
        if (Dungeon.hero.heroClass == HeroClass.MAGE) {
            info.append("\n\n");
            if (this.levelKnown) {
                info.append(LanguageFactory.getTranslation(Utils.format(TXT_DAMAGE, this.MIN + (this.MAX - this.MIN) / 2)));
            } else {
                info.append(LanguageFactory.getTranslation(TXT_WEAPON));
            }
        }
        return info.toString();
    }

    @Override
    public boolean isIdentified() {
        return super.isIdentified() && this.isKnown() && this.curChargeKnown;
    }

    @Override
    public String status() {
        if (this.levelKnown) {
            return (this.curChargeKnown ? Integer.valueOf(this.curCharges) : "?") + "/" + this.maxCharges;
        }
        return null;
    }

    @Override
    public Item upgrade() {
        super.upgrade();
        this.updateLevel();
        this.curCharges = Math.min(this.curCharges + 1, this.maxCharges);
        this.updateQuickslot();
        return this;
    }

    @Override
    public Item degrade() {
        super.degrade();
        this.updateLevel();
        this.updateQuickslot();
        return this;
    }

    protected void updateLevel() {
        this.maxCharges = Math.min(this.initialCharges() + this.level, 9);
        this.curCharges = Math.min(this.curCharges, this.maxCharges);
        this.calculateDamage();
    }

    protected int initialCharges() {
        return 2;
    }

    private void calculateDamage() {
        int tier;
        this.MIN = tier = 1 + this.level / 3;
        this.MAX = (tier * tier - tier + 10) / 2 + this.level;
    }

    protected void fx(int cell, Callback callback) {
        MagicMissile.blueLight(Wand.curUser.sprite.parent, Wand.curUser.pos, cell, callback);
        Sample.INSTANCE.play("snd_zap.mp3");
    }

    protected void wandUsed() {
        --this.curCharges;
        this.updateQuickslot();
        curUser.spendAndNext(1.0f);
    }

    @Override
    public Item random() {
        if (Random.Float() < 0.5f) {
            this.upgrade();
            if (Random.Float() < 0.15f) {
                this.upgrade();
            }
        }
        return this;
    }

    public static boolean allKnown() {
        return handler.known().size() == wands.length;
    }

    @Override
    public int price() {
        int price = 50;
        if (this.cursed && this.cursedKnown) {
            price /= 2;
        }
        if (this.levelKnown) {
            if (this.level > 0) {
                price *= this.level + 1;
            } else if (this.level < 0) {
                price /= 1 - this.level;
            }
        }
        if (price < 1) {
            price = 1;
        }
        return price;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(MAX_CHARGES, this.maxCharges);
        bundle.put(CUR_CHARGES, this.curCharges);
        bundle.put(CUR_CHARGE_KNOWN, this.curChargeKnown);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.maxCharges = bundle.getInt(MAX_CHARGES);
        this.curCharges = bundle.getInt(CUR_CHARGES);
        this.curChargeKnown = bundle.getBoolean(CUR_CHARGE_KNOWN);
    }

    static {
        zapper = new CellSelector.Listener(){

            @Override
            public void onSelect(Integer target) {
                if (target != null) {
                    if (target == curUser.pos) {
                        GLog.i(Wand.TXT_SELF_TARGET, new Object[0]);
                        return;
                    }
                    final Wand curWand = (Wand)curItem;
                    curWand.setKnown();
                    final int cell = Ballistica.cast(curUser.pos, target, true, curWand.hitChars);
                    curUser.sprite.zap(cell);
                    QuickSlot.target(curItem, Actor.findChar(cell));
                    if (curWand.curCharges > 0) {
                        curUser.busy();
                        curWand.fx(cell, new Callback(){

                            @Override
                            public void call() {
                                curWand.onZap(cell);
                                curWand.wandUsed();
                            }
                        });
                        Invisibility.dispel();
                    } else {
                        curUser.spendAndNext(1.0f);
                        GLog.w(Wand.TXT_FIZZLES, new Object[0]);
                        curWand.levelKnown = true;
                        curWand.updateQuickslot();
                    }
                }
            }

            @Override
            public String prompt() {
                return "Choose direction to zap";
            }
        };
    }

    protected class Charger
    extends Buff {
        private static final float TIME_TO_CHARGE = 40.0f;

        protected Charger() {
        }

        @Override
        public boolean attachTo(Char target) {
            super.attachTo(target);
            this.delay();
            return true;
        }

        @Override
        public boolean act() {
            if (Wand.this.curCharges < Wand.this.maxCharges) {
                ++Wand.this.curCharges;
                Wand.this.updateQuickslot();
            }
            this.delay();
            return true;
        }

        protected void delay() {
            float time2charge = ((Hero)this.target).heroClass == HeroClass.MAGE ? 40.0f / (float)Math.sqrt(1 + Wand.this.level) : 40.0f;
            this.spend(time2charge);
        }
    }
}

